/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.StandbyContentManagerElectionCommand;
import com.cognos.pogo.contentmanager.coordinator.ActiveCmFinder;
import com.cognos.pogo.contentmanager.coordinator.CMChangeObserver;
import com.cognos.pogo.handlers.regulate.Stopper;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ActiveCMControl {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private long timeThreshold = 30000L;
    private long timeDelay = 30000L;
    protected static ActiveCMControl instance;
    private List<CMChangeObserver> observerList = new ArrayList<CMChangeObserver>();
    private NodeID localCMNode;
    private boolean currentlyOK = true;
    private Timer timer;
    private boolean localCM;
    private boolean electionErrorOutput;

    protected ActiveCMControl() {
        String localCmProperty = PropertyInserter.getProperty("localCM");
        if (localCmProperty != null) {
            this.localCM = localCmProperty.equals("true");
        }
    }

    public static synchronized ActiveCMControl getInstance() {
        if (instance == null) {
            instance = new ActiveCMControl();
        }
        return instance;
    }

    protected static ActiveCMControl getNewInstanceForTesting() {
        instance = new ActiveCMControl();
        return instance;
    }

    public void addObserver(CMChangeObserver obs) {
        this.observerList.add(obs);
    }

    private boolean notifyCMChanged(String newCMURI) {
        boolean result = true;
        for (CMChangeObserver obs : this.observerList) {
            result &= obs.notifyCMChange(newCMURI);
        }
        return result;
    }

    public void setLocalCMNode(NodeID nodeID) {
        this.localCMNode = nodeID;
    }

    public void setTimeout(int timeout) {
        this.timeDelay = timeout * 1000;
        this.timeThreshold = timeout * 1000;
    }

    public void soapFaultNotify() {
        if (this.checkAndSetCurrentlyOK()) {
            cat.debug("Plugging requests because our last request to CM was to an inactive (standby) CM");
            Stopper.getInstance().plug();
            this.getActive();
        }
    }

    public void cMIOErrorNotify() {
        if (this.checkAndSetCurrentlyOK()) {
            cat.debug("Plugging requests because our last request to CM caused an IOException");
            Stopper.getInstance().plug();
            this.startTimer();
        }
    }

    private synchronized boolean checkAndSetCurrentlyOK() {
        if (this.currentlyOK) {
            this.currentlyOK = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        if (!this.currentlyOK) {
            cat.debug("Active CM Control reset called");
        }
        this.stopTimer();
        ActiveCMControl activeCMControl = this;
        synchronized (activeCMControl) {
            this.notifyAll();
        }
        this.currentlyOK = true;
        this.electionErrorOutput = false;
    }

    public void stopTimer() {
        if (this.timer != null) {
            cat.debug("Cancelling CM control timer");
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void notifyCM(String cmURI) {
        if (this.notifyCMChanged(cmURI)) {
            this.reset();
        }
    }

    public void startupFindCM() {
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getActive() {
        cat.debug("Trying to find active CM after soap fault");
        try {
            ActiveCMControl activeCMControl = this;
            synchronized (activeCMControl) {
                this.wait(this.timeThreshold);
            }
        }
        catch (InterruptedException e) {
            cat.debug("ActiveCMControl.getActive wait interrupted", e);
            return;
        }
        ActiveCmFinder cmFinder = new ActiveCmFinder();
        String activecm = cmFinder.findActiveCM();
        if (activecm != null) {
            cat.debug("Found active CM at ", activecm);
            this.notifyCM(activecm);
        } else {
            cat.debug("Unable to find an active CM (interrupt).  Starting timer");
            this.startTimer();
        }
    }

    private void startTimer() {
        if (this.localCM && !this.sendElectCommand()) {
            this.startElectionTimer();
        }
        this.startGetActiveCMTask();
    }

    private void startElectionTimer() {
        if (this.localCMNode == null) {
            return;
        }
        cat.debug("starting new election timer");
        this.timer = this.createTimer();
        this.timer.schedule((TimerTask)new ElectTask(), 0L, this.timeDelay);
    }

    private void startGetActiveCMTask() {
        cat.debug("starting new getActiveCM timer");
        this.timer = this.createTimer();
        this.timer.schedule((TimerTask)new GetActiveCMTask(), this.timeThreshold, this.timeDelay);
    }

    protected Timer createTimer() {
        return new Timer(true);
    }

    private boolean sendElectCommand() {
        cat.debug("Sending elect() command to CM");
        StandbyContentManagerElectionCommand election = new StandbyContentManagerElectionCommand(this.localCMNode);
        try {
            election.executeIfLocal();
        }
        catch (CommandExecutionException e) {
            if (!this.electionErrorOutput) {
                cat.error(DispatcherStrings.getInstance().getString("electionFailed"));
                this.electionErrorOutput = true;
            }
            return false;
        }
        return true;
    }

    public void cMOkNotify() {
        Stopper.getInstance().unplug();
        NodeID cmNode = NodeIdGuidMapper.getContentManagerNID();
        this.notifyCM(cmNode.getURI());
    }

    public boolean isCurrentlyOK() {
        return this.currentlyOK;
    }

    void setTimer(Timer timer) {
        this.timer = timer;
    }

    private class ElectTask
    extends SafeTimerTask {
        private ElectTask() {
        }

        @Override
        public void safeRun() {
            if (ActiveCMControl.this.sendElectCommand()) {
                this.cancel();
            }
        }
    }

    private class GetActiveCMTask
    extends SafeTimerTask {
        private GetActiveCMTask() {
        }

        @Override
        public void safeRun() {
            cat.debug("Trying to find active CM");
            ActiveCmFinder cmFinder = new ActiveCmFinder();
            String activecm = cmFinder.findActiveCM();
            if (activecm != null) {
                cat.debug("Found active CM at ", activecm);
                ActiveCMControl.this.notifyCM(activecm);
            } else {
                cat.debug("Unable to find an active CM.  Will try sending an elect command");
                ActiveCMControl.this.sendElectCommand();
            }
        }
    }
}

