/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.PogoLogger;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.Node;

public class CMUtils {
    static PogoLogger logger = PogoLogger.getLogger();

    public static String getInvalidService(SoapFaultException sfe) throws SoapFaultException {
        try {
            Element fault = sfe.getFault();
            for (Node node : DomUtils.selectNodes(fault, "//messageString")) {
                String messageString = node.getText();
                if (!CMUtils.messageStringStartsWithErrorNumber(messageString)) continue;
                StringTokenizer tokenizer = new StringTokenizer(messageString, "\"");
                tokenizer.nextToken();
                String invalidClass = tokenizer.nextToken();
                logger.debug("Found invalid class = ", invalidClass);
                return invalidClass;
            }
            throw sfe;
        }
        catch (NullPointerException npe) {
            throw sfe;
        }
    }

    private static boolean messageStringStartsWithErrorNumber(String messageString) {
        String[] messageNumbers;
        for (String number : messageNumbers = new String[]{"CM-REQ-4016", "CM-REQ-4235", "CM-REQ-4010"}) {
            if (!messageString.startsWith(number)) continue;
            return true;
        }
        return false;
    }

    public static String getMessageStrings(SoapFaultException soapFaultException) throws SoapFaultException {
        Element fault = soapFaultException.getFault();
        if (fault == null) {
            throw soapFaultException;
        }
        StringBuilder builder = new StringBuilder();
        for (Node node : DomUtils.selectNodes(fault, "//messageString")) {
            builder.append(node.getText()).append(" ");
        }
        return builder.toString();
    }
}

