/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.coordinator;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.contentmanager.coordinator.PeakTimerTask;
import com.cognos.pogo.contentmanager.coordinator.RefreshControllerReconfigureInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PeakTimeChecker {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PeakTimeChecker.class.getName());
    private static final long DAY_IN_MILLISECONDS = 86400000L;
    private static final String NON_PEAK_DEMAND_BEGIN_HOUR = "nonPeakDemandBeginHour";
    private static final String PEAK_DEMAND_BEGIN_HOUR = "peakDemandBeginHour";
    private static int defaultPeakBeginHour = 7;
    private int peakBeginHour;
    private int nonPeakBeginHour;
    private static int defaultNonPeakBeginHour = 18;
    protected Timer peakTimer;
    ConfigurationImpl configuration;
    final RefreshControllerReconfigureInterface refreshControllerReconfigureInterface;

    public PeakTimeChecker(RefreshControllerReconfigureInterface controller, ConfigurationImpl configuration) {
        this.refreshControllerReconfigureInterface = controller;
        this.configuration = configuration;
    }

    private static boolean betweenHours(int startHour, int currentHour, int endHour) {
        return startHour <= currentHour && currentHour < endHour;
    }

    public void addInPeakToConfig() {
        this.peakBeginHour = this.getBeginHour(PEAK_DEMAND_BEGIN_HOUR, defaultPeakBeginHour);
        this.nonPeakBeginHour = this.getBeginHour(NON_PEAK_DEMAND_BEGIN_HOUR, defaultNonPeakBeginHour);
        boolean inPeakPeriod = this.inPeakPeriod(this.peakBeginHour, this.nonPeakBeginHour);
        try {
            this.configuration.setValue("inPeakDemandPeriod", Boolean.toString(inPeakPeriod));
        }
        catch (CCLConfigurationException e) {
            cat.error("Unable to set inPeakDemandPeriod", (Throwable)e);
        }
    }

    public void checkPeakTimes() {
        int newPeakBeginHour = this.getBeginHour(PEAK_DEMAND_BEGIN_HOUR, defaultPeakBeginHour);
        int newNonPeakBeginHour = this.getBeginHour(NON_PEAK_DEMAND_BEGIN_HOUR, defaultNonPeakBeginHour);
        if (newPeakBeginHour != this.peakBeginHour || newNonPeakBeginHour != this.nonPeakBeginHour) {
            this.addInPeakToConfig();
            this.peakTimer.cancel();
            this.createPeakTimers();
        }
    }

    public void createPeakTimers() {
        this.createTimer();
        try {
            Date peakDate = this.getPeakTime(PEAK_DEMAND_BEGIN_HOUR, defaultPeakBeginHour);
            PeakTimerTask peakTimerTask = new PeakTimerTask(this, "true");
            this.peakTimer.scheduleAtFixedRate((TimerTask)peakTimerTask, peakDate, 86400000L);
        }
        catch (Exception e) {
            cat.error("Unable to parse peakDemandBeginHour. Not setting the peak begin time", (Throwable)e);
        }
        try {
            Date nonPeakDate = this.getPeakTime(NON_PEAK_DEMAND_BEGIN_HOUR, defaultNonPeakBeginHour);
            PeakTimerTask nonPeakTimerTask = new PeakTimerTask(this, "false");
            this.peakTimer.scheduleAtFixedRate((TimerTask)nonPeakTimerTask, nonPeakDate, 86400000L);
        }
        catch (Exception e) {
            cat.error("Unable to parse nonPeakDemandBeginHour. Not setting the non-peak begin time", (Throwable)e);
        }
    }

    protected void createTimer() {
        this.peakTimer = new Timer(true);
    }

    private int getBeginHour(String peakParameterName, int defaultHour) {
        String peakBeginHourStr = this.configuration.getValue(peakParameterName);
        if (peakBeginHourStr == null || "".equals(peakBeginHourStr)) {
            return defaultHour;
        }
        int peakBeginHour = Integer.parseInt(peakBeginHourStr);
        return peakBeginHour;
    }

    public static boolean inPeakPeriod(int currentHour, int peakBeginHour, int nonPeakBeginHour) {
        if (peakBeginHour <= nonPeakBeginHour) {
            return PeakTimeChecker.betweenHours(peakBeginHour, currentHour, nonPeakBeginHour);
        }
        return !PeakTimeChecker.betweenHours(nonPeakBeginHour, currentHour, peakBeginHour);
    }

    private Date getPeakTime(String peakParameterName, int defaultHour) throws NumberFormatException {
        int peakBeginHour = this.getBeginHour(peakParameterName, defaultHour);
        Calendar peakCalendar = Calendar.getInstance();
        peakCalendar.set(11, peakBeginHour);
        peakCalendar.set(12, 0);
        peakCalendar.set(13, 0);
        if (peakCalendar.before(Calendar.getInstance())) {
            peakCalendar.add(11, 24);
        }
        return peakCalendar.getTime();
    }

    private boolean inPeakPeriod(int peakBeginHour, int nonPeakBeginHour) {
        int currentHour = Calendar.getInstance().get(11);
        return PeakTimeChecker.inPeakPeriod(currentHour, peakBeginHour, nonPeakBeginHour);
    }
}

