/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.contentmanager.service;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerAddCommand;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.util.PogoLogger;

public class ContentManagerAddService {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String RUNNING = "running";
    private final Service service;
    private final ContentManagerAddCommand addCommand;
    private String dispatcherPath;

    public ContentManagerAddService(Service service, ContentManagerAddCommand addCommand) {
        this.service = service;
        this.addCommand = addCommand;
    }

    public ContentManagerAddService(Service service) {
        this(service, new ContentManagerAddCommand());
    }

    public void execute() {
        String serviceName = this.service.getName();
        log.info("Adding service object ", serviceName);
        this.addService(serviceName);
        this.addInstalledComponent(serviceName);
        this.executeAddCommand(serviceName);
    }

    private void addService(String serviceName) {
        this.addCommand.setSearch(this.dispatcherPath);
        this.addCommand.addObject(serviceName);
        this.addCommand.setDefaultName(this.service.getCMdefaultName());
        this.addCommand.setRunningState(RUNNING);
    }

    private void addInstalledComponent(String serviceName) {
        this.addCommand.addObject("installedComponent");
        this.addCommand.setDefaultName("installedComponent" + serviceName);
        this.addCommand.setComponentID(serviceName);
    }

    private void executeAddCommand(String serviceName) {
        this.addCommand.setDoTrustedRequest(true);
        try {
            this.addCommand.execute();
        }
        catch (CommandExecutionException e) {
            log.error("Unable to add service ", serviceName, e);
        }
    }

    public void setDispatcherPath(String dispatcherPath) {
        this.dispatcherPath = dispatcherPath;
    }
}

