/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.dropin;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.osgi.launcher.DirectoryWatcher;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DropinFolderMonitor
implements PogoTimerOwner {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String FILE_NOTIFICATION_MBEAN = "WebSphere:service=com.ibm.ws.kernel.filemonitor.FileNotificationMBean";
    private long scanTime = 5000L;
    private PogoTimer timer;
    private DirectoryWatcher directoryWatcher;
    private MBeanServer server;

    public DropinFolderMonitor(String directory) {
        this(directory, DropinFolderMonitor.getMBeanServer());
    }

    public DropinFolderMonitor(String directory, MBeanServer server) {
        this.directoryWatcher = new DirectoryWatcher(directory);
        this.server = server;
    }

    public void setScanTime(long scanTime) {
        this.scanTime = scanTime;
    }

    protected void notifyFileChanges(ArrayList<String> filesToAdd, ArrayList<String> filesToUpdate, ArrayList<String> filesToRemove) {
        if (filesToAdd.isEmpty() && filesToUpdate.isEmpty() && filesToRemove.isEmpty()) {
            return;
        }
        try {
            ObjectName servletMBean = ObjectName.getInstance(FILE_NOTIFICATION_MBEAN);
            if (this.server.isRegistered(servletMBean)) {
                this.dumpFilenames(filesToAdd, filesToUpdate, filesToRemove);
                Object[] params = new Object[]{filesToAdd, filesToUpdate, filesToRemove};
                String[] signature = new String[]{"java.util.Collection", "java.util.Collection", "java.util.Collection"};
                this.server.invoke(servletMBean, "notifyFileChanges", params, signature);
            }
        }
        catch (JMException e) {
            log.debug("Unable to notify dropin update ", e);
        }
    }

    private void dumpFilenames(ArrayList<String> filesToAdd, ArrayList<String> filesToUpdate, ArrayList<String> filesToRemove) {
        log.debug("Adding dropins ", filesToAdd);
        log.debug("Updating dropins ", filesToUpdate);
        log.debug("Removing dropins ", filesToRemove);
    }

    private static MBeanServer getMBeanServer() {
        return PogoMBeanServer.getInstance().getServer();
    }

    public void watch() {
        this.timer = new PogoTimer(this, null, 0L, this.scanTime);
    }

    public void synchronize() {
        this.directoryWatcher.scanDirectory();
        this.synchronizeFiles();
        this.directoryWatcher.setFileModifiedTimes();
    }

    private void synchronizeFiles() {
        ArrayList<String> filesToAdd = this.directoryWatcher.getFileNamesToAdd();
        ArrayList<String> filesToUpdate = this.directoryWatcher.getFileNamesToUpdate();
        ArrayList<String> filesToRemove = this.directoryWatcher.getFileNamesToRemove();
        this.notifyFileChanges(filesToAdd, filesToUpdate, filesToRemove);
    }

    @Override
    public void handleTimeoutEvent(Object parameter) throws Exception {
        this.synchronize();
    }

    public void stop() {
        this.timer.cancel();
    }
}

