/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.caf;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.CAFHandler;
import com.cognos.pogo.pdk.CAFRuntimeException;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import javax.servlet.http.Cookie;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class CAFCookieSettingHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(CAFCookieSettingHandler.class.getName());
    private boolean test = false;

    public CAFCookieSettingHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String respEnvName;
        BIBusEnvelope respEnv;
        if ("true".equals(mc.getProperty("soapActionIsNotSupportedLocally"))) {
            cat.debug("invokeImpl: Skipping CAF because soapActionIsNotSupportedLocally");
            return;
        }
        Cookie[] cookies = null;
        if (this.test) {
            cat.debug("test mode: setting one cookie");
            cookies = new Cookie[]{new Cookie("BogusCookieName", "bogus_cookie_value")};
        } else {
            CAFHandler cafHandler = (CAFHandler)mc.getProperty("caf.CAFHandler");
            if (cafHandler == null) {
                cat.debug("cafHandler is not set in MessageContext, do nothing.");
                return;
            }
            Boolean setCookie = (Boolean)mc.getProperty("setCookieInThisDispatcher");
            if (!setCookie.booleanValue()) {
                return;
            }
            String passportid = (String)mc.getProperty("auth.passportid");
            if (cat.isDebugEnabled()) {
                cat.debug("calling getCookiesToSet with auth.passportid = " + passportid);
            }
            try {
                cookies = cafHandler.getCookiesToSet(passportid);
            }
            catch (CAFRuntimeException ex) {
                mc.setFault(new Fault("CAF_ERRPAGE_CONTACTADMIN", ex));
                return;
            }
            if (cookies == null || cookies.length == 0) {
                cat.debug("cafHandler.getCookiesToSet() returned null or empty array - no cookies to set");
                return;
            }
        }
        String responseName = mc.getResponseName();
        if (responseName == null) {
            responseName = "response";
        }
        if ((respEnv = (BIBusEnvelope)mc.getProperty(respEnvName = responseName + ".envelope")) == null) {
            cat.warn("Cookies not set because no response envelope found in message context as: " + respEnvName);
            return;
        }
        if (cat.isDebugEnabled()) {
            cat.debug("setting " + cookies.length + " cookies");
        }
        respEnv.addSetCookiesServlet(cookies);
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.test = Boolean.valueOf(this.getConfig().attributeValue("test"));
    }

    public void setTest(boolean _test) {
        this.test = _test;
    }
}

