/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager;

import com.cognos.pogo.handlers.contentmanager.GetDataProcessor;
import com.cognos.pogo.handlers.contentmanager.GzippedSearchPathExpander;
import com.cognos.pogo.pdk.MessageContext;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class GzipGetDataProcessor
extends GetDataProcessor {
    private static Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(GzipGetDataProcessor.class.getName());
    private static byte[] CONTENT_LENGTH_BYTES = "Content-Length: 0\r\n\r\n".getBytes();
    private String passportID;

    GzipGetDataProcessor(String newPathInfo, MessageContext messageContext) {
        super(newPathInfo, messageContext);
    }

    @Override
    String getPassportID() {
        return this.passportID;
    }

    @Override
    String getSearchPath() {
        String fullSearchPath;
        String encodedSearchPath;
        String childObjectName = null;
        int lastSlash = this.pathInfo.lastIndexOf("/");
        if (lastSlash < 5) {
            encodedSearchPath = this.pathInfo.substring(4);
        } else {
            encodedSearchPath = this.pathInfo.substring(4, lastSlash);
            if (++lastSlash < this.pathInfo.length()) {
                childObjectName = this.pathInfo.substring(lastSlash);
            }
        }
        if ("filelist.xml".equals(childObjectName)) {
            GzipGetDataProcessor.makeDummyResponse(this.mc);
            this.mc.setProperty("cm.queryCM", Boolean.FALSE);
            this.mc.setProperty("response.status_code", "200");
            this.mc.setProperty("response.headers", new InternetHeaders());
            ByteArrayInputStream dataStream = new ByteArrayInputStream(CONTENT_LENGTH_BYTES);
            ArrayList<ByteArrayInputStream> attachmentList = new ArrayList<ByteArrayInputStream>();
            attachmentList.add(dataStream);
            this.mc.setProperty("response.attachments", attachmentList.iterator());
            return null;
        }
        GzippedSearchPathExpander expander = new GzippedSearchPathExpander(encodedSearchPath);
        String decodedSearchPath = null;
        try {
            decodedSearchPath = expander.getSearchPath();
        }
        catch (Exception ex) {
            if (category.isDebugEnabled()) {
                category.debug("Unable to decode/uncompress searchPath");
                category.debug(encodedSearchPath);
            }
            GzipGetDataProcessor.makeDummyResponse(this.mc);
            this.mc.setProperty("cm.queryCM", Boolean.FALSE);
            return null;
        }
        int semicolonPosition = decodedSearchPath.indexOf(";");
        if (semicolonPosition == -1) {
            category.debug("The decoded string is missing the passport ID delimiter");
            GzipGetDataProcessor.makeDummyResponse(this.mc);
            this.mc.setProperty("cm.queryCM", Boolean.FALSE);
            return null;
        }
        if (semicolonPosition != 0) {
            this.passportID = decodedSearchPath.substring(0, semicolonPosition);
        }
        decodedSearchPath = decodedSearchPath.substring(semicolonPosition + 1);
        if (childObjectName == null) {
            fullSearchPath = decodedSearchPath;
        } else {
            StringBuffer strBuf = new StringBuffer(decodedSearchPath);
            fullSearchPath = strBuf.append("/*[@name='").append(childObjectName).append("']").toString();
        }
        return fullSearchPath;
    }
}

