/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager;

import com.cognos.pogo.util.base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;

public class GzippedSearchPathExpander {
    private String zippedExpression;
    private String unzippedExpression;

    public GzippedSearchPathExpander(String expression) {
        this.zippedExpression = expression;
    }

    public synchronized String getSearchPath() throws IOException, UnsupportedEncodingException {
        if (this.unzippedExpression == null) {
            this.unzippedExpression = this.unzipExpression();
        }
        return this.unzippedExpression;
    }

    private String unzipExpression() throws IOException, UnsupportedEncodingException {
        byte[] buffer = new byte[1024];
        byte[] gzippedBytes = base64.decode(1, this.zippedExpression);
        ByteArrayOutputStream decodedStream = new ByteArrayOutputStream(gzippedBytes.length);
        GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(gzippedBytes));
        int bytesRead = gzipStream.read(buffer);
        while (bytesRead != -1) {
            decodedStream.write(buffer, 0, bytesRead);
            bytesRead = gzipStream.read(buffer);
        }
        return decodedStream.toString("UTF-8");
    }
}

