/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager.viewer;

import com.cognos.pogo.bibus.BIBusCommand;
import com.cognos.pogo.contentmanager.ContentManagerMultipleQueryCommand;
import com.cognos.pogo.handlers.contentmanager.viewer.SoapEncodingUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AddGrandparentToQueryHandler
extends BasicHandler {
    private static PogoLogger log = PogoLogger.getLogger();
    private static final QName QUERY_QNAME = new QName("query", BIBusCommand.BUS_NAMESPACE);

    public AddGrandparentToQueryHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (SoapEncodingUtils.hasValidViewerInput(envelope)) {
            this.addParentToQuery(envelope);
        }
    }

    void addParentToQuery(BIBusEnvelope envelope) {
        Element body = envelope.getBody();
        Element queryElement = body.element(QUERY_QNAME);
        Element firstQueryItem = this.findFirstQueryItem(queryElement);
        if (firstQueryItem == null) {
            firstQueryItem = this.singleToMultiRequestsQuery(queryElement);
        }
        this.addNameToFirstQueryItem(firstQueryItem);
        this.addGrandparentQueryItem(firstQueryItem.getParent());
    }

    private void addNameToFirstQueryItem(Element queryElement) {
        Element properties = (Element)queryElement.selectSingleNode("properties");
        this.addDefaultNameToProperties(properties);
    }

    private void addGrandparentQueryItem(Element requestsElement) {
        Element queryItem = this.addQueryItem(requestsElement);
        String searchParent = this.getSearchParent(requestsElement);
        Element searchElement = queryItem.addElement("search");
        searchElement.addText(searchParent);
        Element propertiesElement = queryItem.addElement("properties");
        this.addDefaultNameToProperties(propertiesElement);
    }

    private void addDefaultNameToProperties(Element propertiesElement) {
        this.addPropertiesItem(propertiesElement, "defaultName");
    }

    private void addPropertiesItem(Element propertiesElement, String itemName) {
        propertiesElement.addElement("item").addText(itemName);
    }

    private String getSearchParent(Element requestsElement) {
        return requestsElement.selectSingleNode("//search").getText() + "/../..";
    }

    Element singleToMultiRequestsQuery(Element queryElement) {
        List<Element> queryChildElements = this.getElements(queryElement);
        Element requestsElement = this.addRequestsElement(queryElement);
        Element firstQuery = this.addQueryItem(requestsElement);
        for (Element element : queryChildElements) {
            firstQuery.add(element.detach());
        }
        return firstQuery;
    }

    private List<Element> getElements(Element queryElement) {
        return queryElement.elements();
    }

    private Element findFirstQueryItem(Element queryElement) {
        String busPrefix = this.getBusPrefix(queryElement);
        String xpath = ".//*[@" + SOAPEnvelope.XSI_TYPE.getNamespacePrefix() + ":" + SOAPEnvelope.XSI_TYPE.getName() + "='" + busPrefix + ":queryRequest']";
        Element firstQuery = (Element)queryElement.selectSingleNode(xpath);
        return firstQuery;
    }

    private Element addQueryItem(Element element) {
        return ContentManagerMultipleQueryCommand.addQueryItemToElement(element);
    }

    private Element addRequestsElement(Element element) {
        return ContentManagerMultipleQueryCommand.addRequestsElement(element);
    }

    private String getBusPrefix(Element element) {
        Namespace busNamespace = element.getNamespaceForURI(BIBusCommand.BUS_NAMESPACE.getURI());
        String busPrefix = busNamespace.getPrefix();
        return busPrefix;
    }
}

