/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager.viewer;

import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.DomUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.dom4j.Element;

public class ReportNameExtractor {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss.SSS'Z'");
    private final Element responseElement;

    public ReportNameExtractor(Element responseElement) {
        this.responseElement = responseElement;
    }

    public String getReportName() {
        Element itemElement = this.getItemElementForType("cm:report");
        if (itemElement != null) {
            return this.getDefaultNameWithTimestamp(itemElement);
        }
        itemElement = this.getItemElementForType("cm:query");
        if (itemElement != null) {
            return this.getDefaultNameWithTimestamp(itemElement);
        }
        itemElement = this.getItemElementForType("cm:output");
        if (itemElement != null) {
            return this.getDefaultName(itemElement);
        }
        return this.getTimestamp();
    }

    private String getDefaultName(Element itemElement) {
        Element defaultName = (Element)itemElement.selectSingleNode("defaultName/value");
        return defaultName.getTextTrim();
    }

    private String getDefaultNameWithTimestamp(Element itemElement) {
        return this.getDefaultName(itemElement) + " " + this.getTimestamp();
    }

    protected String getTimestamp() {
        return dateFormat.format(new Date());
    }

    private Element getItemElementForType(String objectClass) {
        List<Element> itemList = DomUtils.selectElements(this.responseElement, "//returns/item/queryResult/item");
        for (Element element : itemList) {
            String attributeValue = element.attributeValue(SOAPEnvelope.XSI_TYPE);
            if (!attributeValue.equals(objectClass)) continue;
            return element;
        }
        return null;
    }
}

