/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.contentmanager.viewer;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.pdk.BIBusEnvelope;

public class SoapEncodingUtils {
    private static boolean ignoreSoapEncodingVerification = false;

    public static boolean verifySoapEncoding(String methodParams) {
        if (ignoreSoapEncodingVerification) {
            return true;
        }
        return SoapEncodingUtils.verifySoapEncodingMatchesTemplate(methodParams);
    }

    private static boolean verifySoapEncodingMatchesTemplate(String methodParams) {
        boolean matching = methodParams.matches("^SM=query&search=[^&]+(&[^S][^=]+=[^&]+){0,2}+&SA=[^&]+&ITEM=data&EA=&SS=queryOptions[^o]+options&dataEncoding=[^&]+&ES=&EM=$");
        return matching;
    }

    public static void addMethodParamsToEnvironment(String methodParams, BIBusEnvelope requestEnvelope) {
        requestEnvelope.setEnvironment("SMEMinput", methodParams);
    }

    static String getSMEMinput(BIBusEnvelope envelope) {
        return envelope.getEnvironmentValue("SMEMinput");
    }

    public static boolean hasValidViewerInput(BIBusEnvelope envelope) {
        if (SoapEncodingUtils.hasViewerFormValue(envelope)) {
            return true;
        }
        return SoapEncodingUtils.hasSmemInput(envelope);
    }

    private static boolean hasViewerFormValue(BIBusEnvelope envelope) {
        String viewer = envelope.getFormValue("viewer");
        return Boolean.parseBoolean(viewer);
    }

    private static boolean hasSmemInput(BIBusEnvelope envelope) {
        String smemInput = SoapEncodingUtils.getSMEMinput(envelope);
        return smemInput != null && SoapEncodingUtils.verifySoapEncodingMatchesTemplate(smemInput);
    }

    public static boolean setIgnoreSoapEncodingVerificationForTesting(boolean newValue) {
        boolean oldValue = ignoreSoapEncodingVerification;
        ignoreSoapEncodingVerification = newValue;
        return oldValue;
    }

    static {
        String ignoreSoapEncodingVerificationStr = PropertyInserter.getProperty("ignoreSoapEncodingVerification");
        ignoreSoapEncodingVerification = Boolean.valueOf(ignoreSoapEncodingVerificationStr);
    }
}

