/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.handlers.fault.IfFaultHandler;
import com.cognos.pogo.handlers.logic.ChainHandler;
import com.cognos.pogo.handlers.logic.IfElseHandler;
import com.cognos.pogo.handlers.logic.IfHandler;
import com.cognos.pogo.handlers.performance.PerformanceIndicationHandler;
import com.cognos.pogo.impl.PogoEngineImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.HandlerPool;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DescribeHandler
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DescribeHandler.class.getName());
    protected Element xmlConfigData;
    PogoEngineImpl pogoEngine;
    HandlerPool hp;
    private static ThreadLocal<MutableBool> tlRecursedFlag = new ThreadLocal<MutableBool>(){

        @Override
        protected synchronized MutableBool initialValue() {
            return new MutableBool(false);
        }
    };

    private static boolean getServiceLookupRecursed() {
        MutableBool mb = tlRecursedFlag.get();
        return mb.get();
    }

    private static void setServiceLookupRecursed(boolean _b) {
        MutableBool mb = tlRecursedFlag.get();
        mb.set(_b);
    }

    public DescribeHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = (PogoEngineImpl)engine;
        this.xmlConfigData = this.getConfig();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String action = env.getFormValue("b_action");
        this.hp = this.pogoEngine.getHandlerPool();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("dispatcher");
        DescribeHandler.setServiceLookupRecursed(false);
        this.processHandlers(this.pogoEngine.getRootHandler(), root);
        ByteArrayOutputStream baosXML = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(baosXML);
            pw.println(root.asXML());
            pw.close();
            DescribeHandler.prepareResponse(mc, "text/xml", baosXML.toByteArray());
        }
        catch (IOException x) {
            Fault f = new Fault("IOexception preparing response.", x);
            f.setMessageParameters(new Object[]{action});
            mc.setFault(f);
        }
    }

    private void processHandlers(Handler h, Element root) {
        cat.debug(h.getName());
        Element elHandler = root.addElement("handler").addAttribute("name", h.getName());
        elHandler.addAttribute("class", h.getClass().getName());
        this.hasChildren(h, elHandler);
    }

    private void hasChildren(Handler h, Element elHandler) {
        PerformanceIndicationHandler pih;
        String handlerName = h.getClass().getName();
        cat.debug(handlerName);
        if (handlerName.compareTo("com.cognos.pogo.handlers.logic.ChainHandler") == 0) {
            Element elChild = elHandler.addElement("child_handler");
            ChainHandler ch = (ChainHandler)h;
            for (Handler handler : ch.getChain()) {
                if (handler == null) continue;
                this.processHandlers(handler, elChild);
            }
        } else if (handlerName.compareTo("com.cognos.pogo.handlers.logic.IfElseHandler") == 0) {
            IfElseHandler ieh = (IfElseHandler)h;
            elHandler.addAttribute("condition", ieh.getCondition());
            if (ieh.getIfHandler() != null) {
                Element eleIf = elHandler.addElement("TRUE");
                this.processHandlers(ieh.getIfHandler(), eleIf);
            }
            if (ieh.getElseHandler() != null) {
                Element eleElse = elHandler.addElement("FALSE");
                this.processHandlers(ieh.getElseHandler(), eleElse);
            }
        } else if (h instanceof IfHandler) {
            IfHandler ifh = (IfHandler)h;
            elHandler.addAttribute("condition", ifh.getCondition());
            if (ifh.getIfHandler() != null) {
                Element eleIf = elHandler.addElement("TRUE");
                this.processHandlers(ifh.getIfHandler(), eleIf);
            }
        } else if (handlerName.equals("com.cognos.pogo.handlers.engine.ServiceLookupHandler")) {
            if (DescribeHandler.getServiceLookupRecursed()) {
                elHandler.addElement("wouldRecurse");
                return;
            }
            DescribeHandler.setServiceLookupRecursed(true);
            for (Map.Entry<String, Handler> me : this.pogoEngine.getServiceMap().entrySet()) {
                Element elService = elHandler.addElement("service").addAttribute("name", me.getKey());
                this.processHandlers(me.getValue(), elService);
            }
            DescribeHandler.setServiceLookupRecursed(false);
        } else if (handlerName.equals("com.cognos.pogo.handlers.fault.IfFaultHandler")) {
            IfFaultHandler ifh = (IfFaultHandler)h;
            if (ifh != null) {
                Element elFault = elHandler.addElement("fault_handler");
                this.processHandlers(ifh.getFaultHandler(), elFault);
            }
        } else if (h instanceof PerformanceIndicationHandler && (pih = (PerformanceIndicationHandler)h) != null) {
            Element elProfiled = elHandler.addElement("profiled");
            this.processHandlers(pih.getProfiledHandler(), elProfiled);
        }
    }

    private static class MutableBool {
        private boolean b;

        MutableBool(boolean _b) {
            this.b = _b;
        }

        boolean get() {
            return this.b;
        }

        void set(boolean _b) {
            this.b = _b;
        }
    }
}

