/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.mail.internet.InternetHeaders;
import org.apache.soap.util.mime.MimeUtils;

public class EchoHandler
extends BasicHandler {
    private static final String CRLF = "\r\n";

    public EchoHandler() {
        super(null);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            String boundary = MimeUtils.getUniqueValue();
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-Type", "multipart/related; boundary=" + boundary);
            SOAPEnvelope requestEnvelope = (SOAPEnvelope)mc.getProperty("request.envelope");
            Iterator<InputStream> it = this.getRequestAttachments(mc);
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            body.write("SOAPEnvelope\r\n============\r\n\r\n".getBytes());
            requestEnvelope.writeAsXML(body);
            if (it != null) {
                byte[] buffer = new byte[8192];
                int i = 1;
                while (it.hasNext()) {
                    String attachmentLine = "\r\n\r\nAttachment " + i + "\r\n============\r\n\r\n";
                    body.write(attachmentLine.getBytes());
                    InputStream inStream = it.next();
                    int bytesRead = inStream.read(buffer);
                    while (bytesRead != -1) {
                        body.write(buffer, 0, bytesRead);
                        bytesRead = inStream.read(buffer);
                    }
                    ++i;
                }
            }
            body.write("\r\n\r\nEnd of Request".getBytes());
            body.flush();
            byte[] bodyBytes = body.toByteArray();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] CRLF_BYTES = CRLF.getBytes();
            baos.write("Content-Type: text/plain".getBytes());
            baos.write(CRLF_BYTES);
            baos.write("Content-Length: ".getBytes());
            baos.write(String.valueOf(bodyBytes.length).getBytes());
            baos.write(CRLF_BYTES);
            baos.write(CRLF_BYTES);
            body.writeTo(baos);
            baos.flush();
            ArrayList<ByteArrayInputStream> content = new ArrayList<ByteArrayInputStream>(1);
            content.add(new ByteArrayInputStream(baos.toByteArray()));
            mc.setResponseName("response");
            mc.setProperty("response.envelope", new BIBusEnvelope());
            mc.setProperty("response.headers", headers);
            mc.setProperty("response.status_code", "200");
            mc.setProperty("response.status_msg", "OK");
            mc.setProperty("response.boundary", boundary);
            mc.setProperty("response.attachments", content.iterator());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Iterator<InputStream> getRequestAttachments(MessageContext mc) {
        return (Iterator)mc.getProperty("request.attachments");
    }
}

