/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.p2pd.util.DOMWriter;
import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.ParamBucket;
import com.cognos.pogo.transport.url2soap.InputStruct;
import com.cognos.pogo.transport.url2soap.ParameterList;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterRecordingHandler
extends UtilHandlerBase {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(JMeterRecordingHandler.class.getName());
    private Writer wr_jmeter = null;
    static int count = 0;

    public JMeterRecordingHandler() {
        super(cat);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.wr_jmeter != null) {
            String soapAction = mc.getStrProperty("request.soapaction");
            if (soapAction != null && soapAction.indexOf("jmeter") != -1) {
                return;
            }
            ParamBucket param_bucket = (ParamBucket)mc.getProperty("request.param_bucket");
            String method = (String)mc.getProperty("request.method");
            ParameterList paramList = (ParameterList)mc.getProperty("request.URL2SOAPParameterList");
            if (param_bucket == null) {
                return;
            }
            this.recordForJMeter(param_bucket, paramList, method);
        }
    }

    void startJMeterRecording(MessageContext mc, String sfile) throws IOException {
        this.stopJMeterRecording();
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        cat.info("start recording for JMeter to file: " + sfile);
        FileOutputStream fos_jmeter = new FileOutputStream(sfile);
        this.wr_jmeter = new BufferedWriter(new OutputStreamWriter(fos_jmeter));
        this.wr_jmeter.write("<HttpTestSample type=\"org.apache.jmeter.protocol.http.control.HttpTestSample\" name=\"Warp Samples\">\n");
        this.wr_jmeter.write("<defaultUrl>\n");
        this.wr_jmeter.write("<ConfigElement type=\"org.apache.jmeter.protocol.http.config.UrlConfig\">\n");
        this.wr_jmeter.write("<property name=\"PROTOCOL\">http</property>\n");
        this.wr_jmeter.write("<property name=\"port\">");
        this.wr_jmeter.write(requestEnvelope.getEnvironmentValue("SERVER_PORT"));
        this.wr_jmeter.write("</property>\n");
        this.wr_jmeter.write("<property name=\"domain\">");
        this.wr_jmeter.write(requestEnvelope.getEnvironmentValue("SERVER_NAME"));
        this.wr_jmeter.write("</property>\n");
        this.wr_jmeter.write("<property name=\"path\">");
        this.wr_jmeter.write(requestEnvelope.getEnvironmentValue("SCRIPT_NAME"));
        this.wr_jmeter.write("</property>\n");
        this.wr_jmeter.write("</ConfigElement>\n");
        this.wr_jmeter.write("</defaultUrl>\n");
        this.wr_jmeter.write("<urlList>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopJMeterRecording() throws IOException {
        if (this.wr_jmeter == null) {
            return;
        }
        cat.info("stop recording for JMeter.");
        Writer writer = this.wr_jmeter;
        synchronized (writer) {
            try {
                this.wr_jmeter.flush();
                this.wr_jmeter.write("</urlList>\n");
                this.wr_jmeter.write("<configElements/>\n");
                this.wr_jmeter.write("<controllers/>\n");
                this.wr_jmeter.write("</HttpTestSample>\n");
            }
            finally {
                try {
                    this.wr_jmeter.close();
                }
                catch (Exception exception) {}
                this.wr_jmeter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordForJMeter(ParamBucket param_bucket, ParameterList paramList, String requestMethod) {
        try {
            Writer writer = this.wr_jmeter;
            synchronized (writer) {
                this.wr_jmeter.write("<ConfigElement type=\"org.apache.jmeter.protocol.http.config.UrlConfig\">\n");
                this.wr_jmeter.write("<property name=\"name\">");
                this.wr_jmeter.write("sample_");
                this.wr_jmeter.write(Integer.toString(++count));
                this.wr_jmeter.write("</property>\n");
                this.wr_jmeter.write("<property name=\"arguments\">\n");
                this.wr_jmeter.write("<Arguments>\n");
                Iterator<String> itnames = param_bucket.getNames();
                while (itnames.hasNext()) {
                    String name = itnames.next();
                    for (String value : param_bucket.getValues(name)) {
                        this.wr_jmeter.write("<argument name=\"");
                        this.wr_jmeter.write(name);
                        this.wr_jmeter.write("\">");
                        this.wr_jmeter.write(DOMWriter.normalize(value, false));
                        this.wr_jmeter.write("</argument>\n");
                    }
                }
                if (paramList != null) {
                    ListIterator<InputStruct> itU2Sparams = paramList.listIterator();
                    while (itU2Sparams.hasNext()) {
                        InputStruct parm = (InputStruct)itU2Sparams.next();
                        this.wr_jmeter.write("<argument name=\"");
                        this.wr_jmeter.write(parm.getName());
                        this.wr_jmeter.write("\">");
                        String value = parm.getType() != null ? parm.getType() + "," + parm.getValue() : parm.getValue();
                        this.wr_jmeter.write(DOMWriter.normalize(value, false));
                        this.wr_jmeter.write("</argument>\n");
                        if (!cat.isDebugEnabled()) continue;
                        cat.debug("recorded " + parm.getName() + "=" + value);
                    }
                }
                this.wr_jmeter.write("</Arguments>");
                this.wr_jmeter.write("</property>");
                this.wr_jmeter.write("<property name=\"method\">");
                this.wr_jmeter.write(requestMethod);
                this.wr_jmeter.write("</property>\n");
                this.wr_jmeter.write("</ConfigElement>\n");
                this.wr_jmeter.flush();
            }
        }
        catch (IOException x) {
            cat.warn("IOException writing jmeter file.", (Throwable)x);
            try {
                this.wr_jmeter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wr_jmeter = null;
        }
    }
}

