/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Node;

public class LogFaultHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(LogFaultHandler.class.getName());
    private Logger faultLogger;
    private String logCategoryName;
    private String headerMessage;

    public LogFaultHandler() {
        super(cat);
    }

    public String getLogCategoryName() {
        return this.logCategoryName;
    }

    public String getHeaderMessage() {
        return this.headerMessage;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (!this.faultLogger.isInfoEnabled() || !mc.isFaulted()) {
            return;
        }
        Fault o = mc.getFault();
        if (o == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\n').append(this.headerMessage).append('\n');
        if (o instanceof SOAPEnvelope) {
            sb.append(((SOAPEnvelope)((Object)o)).getEnvelope().asXML());
        } else if (o instanceof Node) {
            sb.append(((Node)o).asXML());
        } else if (o instanceof Fault) {
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            sb.append(o.generateEnvelope(requestEnvelope).getEnvelope().asXML());
        } else {
            sb.append("Unexpected type of fault: " + o.toString());
        }
        this.faultLogger.info(sb.toString());
    }

    @Override
    public void initialize() {
        this.faultLogger = Hierarchy.getDefaultHierarchy().getLoggerFor(this.logCategoryName);
    }

    @Override
    public void compose_impl(PogoEngine arg0) throws PogoException {
        this.logCategoryName = this.getRequiredAttribute(cat, "logCategoryName");
        this.headerMessage = this.getRequiredAttribute(cat, "headerMessage");
    }
}

