/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.debug;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class LogResponseHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(LogResponseHandler.class.getName());
    private boolean prettyPrint;

    public LogResponseHandler() {
        super(logger);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (mc.isFaulted()) {
            this.logEnvelope(new StringBuffer("Response (Fault) envelope"), mc.getFault().generateEnvelope());
            return;
        }
        String responseName = mc.getResponseName();
        if (responseName == null) {
            logger.error("Cannot log: response base name is null.");
            return;
        }
        BIBusEnvelope responseEnvelope = (BIBusEnvelope)mc.getProperty(responseName = responseName + ".envelope");
        if (responseEnvelope == null) {
            logger.error("Response envelope \"" + responseName + "\" is null!");
            return;
        }
        StringBuffer msg = new StringBuffer("Response envelope \"");
        msg.append(responseName).append("\"");
        this.logEnvelope(msg, responseEnvelope);
    }

    private void logEnvelope(StringBuffer msg, SOAPEnvelope envelope) {
        try {
            if (!this.prettyPrint) {
                msg.append(":\n");
                msg.append(envelope.getEnvelope().asXML());
            } else {
                msg.append(", pretty printed:\n");
                msg.append(envelope.getAsString());
            }
            logger.debug(msg.toString());
        }
        catch (Exception e) {
            logger.error("error trying to log response: ", (Throwable)e);
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.prettyPrint = "true".equalsIgnoreCase(this.getRequiredAttribute(logger, "prettyPrint"));
    }
}

