/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.handlers.debug.UtilHandlerBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.GenerateErrorPage;
import com.cognos.pogo.transport.ParamBucket;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.ContentTypeFileExtensions;
import com.cognos.pogo.util.PogoLogger;

public class CacheHandler
extends UtilHandlerBase {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private CAMUtils junitCamUtils = null;
    protected static final ContentTypeFileExtensions contentTypeFileExtensions = new ContentTypeFileExtensions();

    public CacheHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void configure(Configuration configuration) {
    }

    protected void initializeJUnitCrypto(CAMUtils camCSKI) {
        this.junitCamUtils = camCSKI;
        this.junitCamUtils.initialize();
    }

    protected CAMUtils getCrypto() {
        if (this.junitCamUtils != null) {
            return this.junitCamUtils;
        }
        CAMUtils cam = new CAMUtils();
        cam.initialize();
        return cam;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    protected BIBusEnvelope getRequestEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty("request.envelope");
    }

    protected boolean forceAttachmentDispositionType(MessageContext mc) {
        BIBusEnvelope request_env = this.getRequestEnvelope(mc);
        return Boolean.valueOf(request_env.getFormValue("download"));
    }

    private String getBase64UserSessionId(MessageContext mc) {
        BIBusEnvelope envelope = this.getRequestEnvelope(mc);
        return envelope != null ? envelope.getBiBusHeader().getCam().getUserSessionId() : null;
    }

    protected String validbase64CAMUserSessionID(MessageContext mc, CAMUtils cam) throws Exception {
        try {
            String base64usid = this.getBase64UserSessionId(mc);
            if (base64usid == null) {
                cat.debug("NULL userSessionID");
                throw new Exception("NULL userSessionID");
            }
            cam.checkValidCAMUserSessionID(base64usid);
            return base64usid;
        }
        catch (Exception e) {
            cat.error("Failed to read userSessionID during dispatcher cache file serve", e);
            throw e;
        }
    }

    ParamBucket buildParamBucket(BIBusEnvelope envelope) {
        ParamBucket pb = new ParamBucket();
        try {
            pb.parse(envelope.getFormFieldValuesAsQueryString());
            return pb;
        }
        catch (Exception e) {
            cat.debug("Failed to get paramBucket from envelope", e);
            return null;
        }
    }

    protected void replyWith404Error(MessageContext mc, String errorMessage) {
        try {
            GenerateErrorPage errorPage = new GenerateErrorPage("NOT_FOUND");
            errorPage.setResponseStatusCode(Integer.toString(404));
            errorPage.setResponseStatusMsg("File Not Found");
            errorPage.invokeImpl(mc);
        }
        catch (Exception e) {
            cat.error(errorMessage);
            mc.setResponseName("response");
            mc.setProperty("response.envelope", new BIBusEnvelope());
            mc.setProperty("response.status_code", Integer.toString(404));
        }
    }
}

