/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.util.CAMUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class CacheInputStreamFactory {
    private final CAMUtils camUtils;

    public CacheInputStreamFactory(CAMUtils camUtils) {
        this.camUtils = camUtils;
    }

    public InputStream createInputStream(String filePath, boolean compressed, boolean encrypted) throws IOException {
        InputStream inputStream = encrypted ? this.getEncryptedInputStream(filePath) : this.getClearInputStream(filePath);
        if (compressed) {
            inputStream = this.getUncompressedInputStream(inputStream);
        }
        return inputStream;
    }

    private InputStream getUncompressedInputStream(InputStream inputStream) throws IOException {
        return new GZIPInputStream(inputStream);
    }

    protected InputStream getClearInputStream(String filePath) throws IOException {
        return new BufferedInputStream(new FileInputStream(filePath));
    }

    protected InputStream getEncryptedInputStream(String filePath) throws IOException {
        return new BufferedInputStream(this.camUtils.createCipherInputStream(filePath));
    }
}

