/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.pogo.handlers.dispatchercache.CacheFileDescriptor;
import com.cognos.pogo.util.EchoInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DescriptorFileReader {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DescriptorFileReader.class.getName());
    private String dataType = null;
    private String reportName = null;
    private String compressionType = null;
    private String encrypted = null;

    public DescriptorFileReader(String fileName, CacheFileDescriptor cacheFolder) {
        this.parse(fileName, cacheFolder);
    }

    public String parseContentType() {
        return this.dataType;
    }

    public String parseReportName() {
        return this.reportName;
    }

    public String parseCompression() {
        return this.compressionType;
    }

    public String parseEncrypted() {
        return this.encrypted;
    }

    private void parse(String fileName, CacheFileDescriptor cacheFolder) {
        try {
            Element descRootElement = this.parseRootCacheFileDescriptor(fileName, cacheFolder);
            List<Element> paramList = this.getParameters(descRootElement);
            for (Element parameterElem : paramList) {
                String paramName = parameterElem.element("name").getText();
                if (paramName.equals("dataType")) {
                    this.dataType = parameterElem.element("value").getText();
                }
                if (paramName.equals("reportName")) {
                    this.reportName = parameterElem.element("value").getText();
                }
                if (paramName.equals("compressionType")) {
                    this.compressionType = parameterElem.element("value").getText();
                }
                if (!paramName.equals("encrypted")) continue;
                this.encrypted = parameterElem.element("value").getText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Element> getParameters(Element descRootElement) {
        return descRootElement.elements("parameter");
    }

    protected Element parseRootCacheFileDescriptor(String fileName, CacheFileDescriptor cacheFolder) throws FileNotFoundException {
        String fileIdentifier = cacheFolder.getDescriptorIdentifier(fileName);
        FileInputStream fis = new FileInputStream(fileIdentifier);
        if (cat.isDebugEnabled()) {
            return this.debugParseRootCacheFileDescriptor(fileIdentifier, fis);
        }
        return this.getRootCacheFileDescriptor(fileIdentifier, fis, null);
    }

    protected Element debugParseRootCacheFileDescriptor(String fileIdentifier, InputStream fis) throws FileNotFoundException {
        ByteArrayOutputStream baosEcho = new ByteArrayOutputStream();
        EchoInputStream isEcho = new EchoInputStream(baosEcho, fis);
        return this.getRootCacheFileDescriptor(fileIdentifier, isEcho, baosEcho);
    }

    private Element getRootCacheFileDescriptor(String fileIdentifier, InputStream ins, ByteArrayOutputStream baos) {
        Element rootElement;
        block6: {
            rootElement = null;
            try {
                rootElement = this.readInputStream(ins);
            }
            catch (DocumentException e) {
                cat.error("SAXReader exception while processing " + fileIdentifier + " ", (Throwable)e);
                if (baos == null) break block6;
                try {
                    cat.debug(baos.toString("UTF-8"));
                }
                catch (UnsupportedEncodingException e1) {
                    cat.error("UnsupportedEncodingException,", (Throwable)e1);
                }
            }
        }
        try {
            ins.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rootElement;
    }

    private Element readInputStream(InputStream ins) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(ins);
        return doc.getRootElement();
    }
}

