/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache;

import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.handlers.contentmanager.viewer.ContentDispositionCreator;
import com.cognos.pogo.handlers.dispatchercache.CacheByteServeResponseGenerator;
import com.cognos.pogo.handlers.dispatchercache.CacheHandler;
import com.cognos.pogo.handlers.dispatchercache.StringHeaderBuilder;
import com.cognos.pogo.handlers.dispatchercache.io.HeaderInputStream;
import com.cognos.pogo.impl.PogoGETResponder;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.reportservice.ReportServerHandler;
import com.cognos.pogo.transport.MethodDispatcherCacheExtractor;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;

public class RsvpCacheHandler
extends CacheHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            MethodDispatcherCacheExtractor mdce = this.extractParameters(mc);
            this.processRequest(mc, mdce);
            this.generateResponse(mc);
        }
        catch (Exception e) {
            cat.error("Failure during report output retrieval", e);
            this.replyWith404Error(mc, "Failure during report output retrieval");
        }
    }

    private void processRequest(MessageContext mc, MethodDispatcherCacheExtractor mdce) {
        ReportServerHandler handler = this.getReportServerHandler();
        handler.getOutput(mc, mdce);
    }

    protected ReportServerHandler getReportServerHandler() {
        PogoEngine engine = this.getPogoEngine();
        Handler handler = engine.lookupHandler("reportService.warpmta");
        return (ReportServerHandler)handler;
    }

    protected MethodDispatcherCacheExtractor extractParameters(MessageContext mc) throws Exception {
        CAMUtils cam = this.getCrypto();
        String base64usid = this.validbase64CAMUserSessionID(mc, cam);
        try {
            MethodDispatcherCacheExtractor mdce = MethodDispatcherCacheExtractor.getInstance(mc, cam);
            if (mdce == null || mdce.getRSVPId() == null) {
                cat.error("Failed to get URL parameters for report server output retrieval");
                throw new Exception("Report Server ID missing");
            }
            String output = mdce.getFileName();
            if (!mdce.validateURLValues(cam, base64usid)) {
                cat.error("Failed to get URL parameters for report server output retrieval");
                throw new Exception("CAM validation failure");
            }
            return mdce;
        }
        catch (Exception e) {
            cat.error("Failed to get URL parameters for report server output retrieval", e);
            throw e;
        }
    }

    void generateResponse(MessageContext messageContext) throws IOException {
        messageContext.setProperty("pogo.responder", new PogoGETResponder());
        List<InputStream> attachement = this.generateAttachment(messageContext);
        this.setResponse(messageContext, attachement);
    }

    private void setResponse(MessageContext messageContext, List<InputStream> attachement) {
        Integer code = (Integer)messageContext.getProperty("rscache.statusCode");
        messageContext.setProperty("response.status_code", code.toString());
        if (code == 200 || code == 206) {
            messageContext.setProperty("response.attachments", attachement.iterator());
        }
    }

    private ContentDispositionCreator createContentDispositionCreator(String contentType, MessageContext messageContext, String reportName) {
        ContentDispositionCreator contentDispositionCreator = new ContentDispositionCreator(contentType, reportName, contentTypeFileExtensions, this.forceAttachmentDispositionType(messageContext));
        return contentDispositionCreator;
    }

    public void addHeaders(StringHeaderBuilder headers, MessageContext messageContext, String contentType, String reportName) {
        ContentDispositionCreator contentDispositionCreator = this.createContentDispositionCreator(contentType, messageContext, reportName);
        contentDispositionCreator.addHeadersForUserAgent(headers, MimeHeaderUtil.getUserAgent(messageContext));
    }

    private String createAttachmentHeaders(MessageContext messageContext) {
        StringHeaderBuilder headerBuilder = new StringHeaderBuilder();
        String contentType = null;
        String reportName = null;
        InternetHeaders iHeaders = (InternetHeaders)messageContext.getProperty("rscache.headers");
        if (iHeaders != null) {
            Enumeration enumHdrs = iHeaders.getAllHeaders();
            while (enumHdrs.hasMoreElements()) {
                int semicolon;
                Header hdr = (Header)enumHdrs.nextElement();
                String name = hdr.getName();
                String value = hdr.getValue();
                if ("Content-Type".equalsIgnoreCase(name) && value != null) {
                    semicolon = value.indexOf(59);
                    contentType = semicolon > 0 ? value.substring(0, semicolon) : value;
                } else if ("Content-Disposition".equalsIgnoreCase(name) && value != null) {
                    int filename;
                    semicolon = value.indexOf(59);
                    if (semicolon <= 0 || (filename = value.indexOf("filename=\"", semicolon)) <= 0 || !(reportName = value.substring(filename + 10).trim()).endsWith("\"")) continue;
                    reportName = reportName.substring(0, reportName.length() - 1);
                    continue;
                }
                headerBuilder.setHeader(name, value);
            }
        }
        this.addHeaders(headerBuilder, messageContext, contentType, reportName);
        headerBuilder.addEmptyLine();
        return headerBuilder.toString();
    }

    public List<InputStream> generateAttachment(MessageContext messageContext) throws IOException {
        String headers = this.createAttachmentHeaders(messageContext);
        InputStream inputStream = (InputStream)messageContext.getProperty("rscache.response");
        ArrayList<InputStream> attachments = new ArrayList<InputStream>(1);
        attachments.add(this.createAttachment(headers, inputStream));
        return attachments;
    }

    private InputStream createAttachment(String header, InputStream payload) {
        return new HeaderInputStream(header, payload);
    }

    void configureForJUnit(String tempDir, CAMUtils cu, CacheByteServeResponseGenerator generator) {
        this.initializeJUnitCrypto(cu);
    }
}

