/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.dispatchercache.io;

import java.io.IOException;
import java.io.InputStream;

public class RangeInputStream
extends InputStream {
    private final InputStream baseInputStream;
    private final long start;
    private final long end;
    private long current;

    public RangeInputStream(InputStream baseInputStream, long start, long end) {
        this.baseInputStream = baseInputStream;
        this.start = start;
        this.end = end;
    }

    @Override
    public int read() throws IOException {
        if (this.current == 0L) {
            this.baseInputStream.skip(this.start);
            this.current = this.start;
        }
        return this.current++ <= this.end ? this.baseInputStream.read() : -1;
    }

    @Override
    public void close() throws IOException {
        this.baseInputStream.close();
    }
}

