/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AbortIfSuspendedHandler
extends BasicHandler {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(AbortIfSuspendedHandler.class.getName());
    private boolean suspended = false;
    private boolean pendingSuspend = false;
    private boolean suspendedImmediately = false;

    public AbortIfSuspendedHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.suspended && !this.pendingSuspend) {
            RequestAffinity affinity = RequestAffinity.determineAffinity((String)mc.getProperty("request.soapaction"));
            if (!(this.suspendedImmediately || affinity != RequestAffinity.CONTROL && affinity != RequestAffinity.ABSOLUTE)) {
                return;
            }
            mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
        }
    }

    @Override
    public void resume() {
        this.suspended = false;
        this.pendingSuspend = false;
        this.suspendedImmediately = false;
        cat.debug("resume called.  pendingSuspend = false");
    }

    @Override
    public void suspend(boolean immediate) {
        if (!this.suspended) {
            cat.debug("suspend called when not previously suspended.  pendingSuspend = true");
            this.pendingSuspend = true;
            this.suspended = true;
        } else {
            this.pendingSuspend = false;
        }
        this.suspendedImmediately = this.suspendedImmediately || immediate;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.pendingSuspend = false;
        cat.debug("reconfigure called.  pendingSuspend = false");
    }
}

