/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.CROneCookie;
import com.cognos.pogo.util.PogoLogger;
import java.util.Locale;
import java.util.Map;

public class CookieToUserPreferencesConverterHandler
extends BasicHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final int NOT_FOUND = -1;

    public CookieToUserPreferencesConverterHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        CROneCookie userPreferencesFromCookie = this.getUserPreferencesFromCookie(requestEnvelope);
        if (userPreferencesFromCookie != null) {
            this.copyUserPreferencesToRequestEnvelope(userPreferencesFromCookie, requestEnvelope);
        }
        CookieToUserPreferencesConverterHandler.copyLocaleFromUserPreferences(mc, requestEnvelope);
    }

    private CROneCookie getUserPreferencesFromCookie(BIBusEnvelope requestEnvelope) {
        try {
            String cookieString = this.getCR1Cookie(requestEnvelope);
            return cookieString != null ? new CROneCookie(cookieString) : null;
        }
        catch (Exception e) {
            cat.debug("Bad CR1 cookie found, ignored", e);
            return null;
        }
    }

    private String getCR1Cookie(BIBusEnvelope requestEnvelope) {
        String cookie = requestEnvelope.getCookieValue("CRN");
        if (cookie == null) {
            cat.debug("CR1 cookie not found, trying old cookie name");
            cookie = requestEnvelope.getCookieValue("CR1");
        }
        cat.debug("CR1 cookie: ", cookie);
        return cookie;
    }

    private void copyUserPreferencesToRequestEnvelope(CROneCookie userPreferences, BIBusEnvelope envelope) {
        envelope.getBiBusHeader().getUserPreferenceVars().clear();
        for (Map.Entry<String, String> entry : userPreferences.getPreferences().entrySet()) {
            envelope.setUserPreference(entry.getKey(), entry.getValue());
        }
    }

    public static void copyLocaleFromUserPreferences(MessageContext mc, BIBusEnvelope envelope) {
        String productLocale = envelope.getUserPreferenceValue("productLocale");
        cat.debug("Product locale: ", productLocale);
        if (productLocale != null) {
            mc.setProperty("locale", CookieToUserPreferencesConverterHandler.getContextLocale(productLocale));
        }
    }

    private static Locale getContextLocale(String productLocale) {
        int dashPos = productLocale.indexOf(45);
        if (dashPos == -1) {
            return new Locale(productLocale);
        }
        String language = productLocale.substring(0, dashPos);
        String country = productLocale.substring(dashPos + 1);
        return new Locale(language, country);
    }
}

