/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.config.ConfigurationImpl;
import com.cognos.pogo.contentmanager.ContentManagerUpdateCommand;
import com.cognos.pogo.contentmanager.coordinator.CMUtils;
import com.cognos.pogo.handlers.engine.DispatcherStatusHandlerUpdateInterface;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.util.PogoLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;

public class DispatcherStatusHandler
extends BasicHandler
implements DispatcherStatusHandlerUpdateInterface {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private static final String UNABLE_TO_UPDATE = "Unable to update runningState on CM ";
    private static final String DISPATCHER = "dispatcher";
    private ArrayList<Service> dependentServices = new ArrayList();
    private Map<String, String> serviceStatusMap = new HashMap<String, String>();
    private Map<String, String> changedServiceStatusMap = new HashMap<String, String>();
    private String dispatcherSearchPath;
    private PogoEngine pogoEngine;
    private Map<String, Boolean> serviceSuspendableCache = new HashMap<String, Boolean>();

    public DispatcherStatusHandler() {
        super(cat.getNativeLogger());
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
    }

    @Override
    public void configure(Configuration configuration) {
        String localSearchPath = configuration.getLocalSearchPath();
        this.dispatcherSearchPath = localSearchPath != null ? localSearchPath : "";
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
        if (this.needToUpdateRunningState(configuration)) {
            this.sendStatusesToCM(this.serviceStatusMap);
        }
    }

    private boolean needToUpdateRunningState(Configuration configuration) {
        boolean update = false;
        if (configuration instanceof ConfigurationImpl) {
            ConfigurationImpl configurationImpl = (ConfigurationImpl)configuration;
            update = configurationImpl.getForceUpdateRunningStateOnReconfigure();
            if (update) {
                configurationImpl.setForceUpdateRunningStateOnReconfigure(false);
            } else {
                update = configurationImpl.getLocalDispatcherName() != null && !configurationImpl.isLocalDispatcherAvailable() && configurationImpl.getLocalDispatcherElement() != null;
            }
        }
        return update;
    }

    @Override
    public void start() {
        this.serviceStatusMap.put(DISPATCHER, "running");
        this.setServiceStatuses("running");
        this.sendStatusesToCM(this.serviceStatusMap);
    }

    @Override
    public void stop() {
        NodeID node = NodeIdGuidMapper.getContentManagerNID();
        if (node == null) {
            return;
        }
        if (!node.isLocalToSelf()) {
            this.setServiceStatuses("standby");
            this.sendStatusesToCM(this.serviceStatusMap);
        }
    }

    @Override
    public void resume() {
        for (Service service : this.dependentServices) {
            service.resume();
        }
    }

    @Override
    public void suspend(boolean immediate) {
        for (Service service : this.dependentServices) {
            service.suspend(immediate);
        }
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        this.setDispatcherStatusFromDependants();
        this.sendStatusesToCM(this.changedServiceStatusMap);
        this.changedServiceStatusMap.clear();
    }

    @Override
    public void addDependentService(String serviceName, Service service) {
        this.dependentServices.add(service);
        this.serviceStatusMap.put(serviceName, "suspended");
    }

    @Override
    public synchronized void setStatus(String serviceName, String state) {
        cat.debug("setting status of ", serviceName, " to ", state);
        this.serviceStatusMap.put(serviceName, state);
        this.changedServiceStatusMap.put(serviceName, state);
    }

    private synchronized void setServiceStatuses(String state) {
        for (String service : this.serviceStatusMap.keySet()) {
            this.serviceStatusMap.put(service, state);
        }
    }

    private void setDispatcherStatusFromDependants() {
        String oldDispStatus;
        String dispatcherStatus = "suspended";
        for (String service : this.serviceStatusMap.keySet()) {
            String status;
            if (service.equals(DISPATCHER) || !this.serviceIsSuspendable(service) || !(status = this.serviceStatusMap.get(service)).equals("running")) continue;
            dispatcherStatus = "running";
            break;
        }
        if (!dispatcherStatus.equals(oldDispStatus = this.serviceStatusMap.get(DISPATCHER))) {
            this.serviceStatusMap.put(DISPATCHER, dispatcherStatus);
            this.changedServiceStatusMap.put(DISPATCHER, dispatcherStatus);
        }
    }

    private boolean serviceIsSuspendable(String service) {
        Boolean suspendable = this.serviceSuspendableCache.get(service);
        if (suspendable == null) {
            Service realService = this.pogoEngine.getDispatcherServices().getService(service);
            boolean serviceIsSuspendable = realService.isSuspendable();
            this.serviceSuspendableCache.put(service, serviceIsSuspendable);
            return serviceIsSuspendable;
        }
        return suspendable;
    }

    public void updateStatusesToCM() {
        this.sendStatusesToCM(this.serviceStatusMap);
    }

    void sendStatusesToCM(Map<String, String> statusMap) {
        if (statusMap.size() == 0) {
            return;
        }
        try {
            this.sendStatusesToCMWithMessage(statusMap);
        }
        catch (CommandExecutionException cee) {
            cat.error(UNABLE_TO_UPDATE, cee);
        }
    }

    private void sendStatusesToCMWithMessage(Map<String, String> statusMap) throws CommandExecutionException {
        try {
            this.addStatusesToUpdateCommand(statusMap);
        }
        catch (SoapFaultException sfe) {
            cat.error(UNABLE_TO_UPDATE, CMUtils.getMessageStrings(sfe));
        }
    }

    private void addStatusesToUpdateCommand(Map<String, String> statusMap) throws CommandExecutionException {
        String invalidService = this.addValidStatusesToUpdateCommand(statusMap);
        while (invalidService != null) {
            statusMap = this.removeServiceFromMap(statusMap, invalidService);
            invalidService = this.addValidStatusesToUpdateCommand(statusMap);
        }
    }

    private HashMap<String, String> removeServiceFromMap(Map<String, String> statusMap, String invalidService) {
        HashMap<String, String> updatedServiceMap = new HashMap<String, String>(statusMap);
        Iterator<String> iterator = updatedServiceMap.keySet().iterator();
        while (iterator.hasNext()) {
            String service = iterator.next();
            if (!invalidService.equals(service)) continue;
            iterator.remove();
        }
        return updatedServiceMap;
    }

    private String addValidStatusesToUpdateCommand(Map<String, String> statusMap) throws CommandExecutionException {
        ContentManagerUpdateCommand update = this.createUpdateCommand();
        this.addServicesToCommand(statusMap, update);
        update.setDoTrustedRequest(true);
        try {
            update.execute();
        }
        catch (SoapFaultException sfe) {
            return CMUtils.getInvalidService(sfe);
        }
        return null;
    }

    protected ContentManagerUpdateCommand createUpdateCommand() {
        ContentManagerUpdateCommand update = new ContentManagerUpdateCommand();
        return update;
    }

    private void addServicesToCommand(Map<String, String> statusMap, ContentManagerUpdateCommand update) {
        for (Map.Entry<String, String> entry : statusMap.entrySet()) {
            String service = entry.getKey();
            String state = entry.getValue();
            update.addObject(service);
            if (service.equalsIgnoreCase(DISPATCHER)) {
                update.setSearchPath(this.dispatcherSearchPath);
            } else {
                update.setSearchPath(this.dispatcherSearchPath + "/" + service);
            }
            update.setRunningState(state);
        }
    }
}

