/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.handlers.engine.PropagateStatusGlobal;
import com.cognos.pogo.handlers.engine.PropagateStatusLocal;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.util.PogoLogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class PropagateStatus {
    private static PogoLogger log = PogoLogger.getLogger();
    private static final String OBJECT_NAME = "com.cognos:type=RemoteDispatcherUpdates,class=com.cognos.p2plb.clerver.AdditionalServicesUpdater";
    protected static ExecutorService executor;
    protected static ObjectName additionalServicesUpdaterObjectName;
    protected static String localDispatcherName;

    public static PropagateStatus decodeValue(String attributeValue) {
        if (attributeValue == null) {
            return new PropagateStatus();
        }
        if (attributeValue.equalsIgnoreCase("local")) {
            return new PropagateStatusLocal();
        }
        if (attributeValue.equalsIgnoreCase("global")) {
            return new PropagateStatusGlobal();
        }
        return new PropagateStatus();
    }

    public void configure(Configuration configuration) {
        if (configuration == null) {
            return;
        }
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        this.configureFromDispatcherList(dispatcherList);
    }

    protected void configureFromDispatcherList(DispatcherList dispatcherList) {
        localDispatcherName = dispatcherList.getLocalDispatcherName();
    }

    public void propagateStatus() {
    }

    protected static void updateDispatcherOnServer(MBeanServer server, ObjectName objectName) {
        String[][] params = new String[][]{{localDispatcherName}, new String[0]};
        String[] signature = new String[]{"[Ljava.lang.String;", "[Ljava.lang.String;"};
        try {
            server.invoke(ObjectName.getInstance(objectName), "updateDispatchers", (Object[])params, signature);
        }
        catch (JMException e) {
            log.debug("Exception updating dispatcher on server ", e);
        }
    }

    public void shutdown() {
        if (executor != null) {
            executor.shutdown();
        }
    }

    void awaitTermination() {
        try {
            executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getServiceStatusFor(String status) {
        return status;
    }

    static {
        try {
            additionalServicesUpdaterObjectName = ObjectName.getInstance(OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            log.debug("This should never happen", e);
        }
    }

    public final class DaemonThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

