/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.engine;

import com.cognos.pogo.handlers.engine.DispatcherStatusHandlerUpdateInterface;
import com.cognos.pogo.handlers.engine.PropagateStatus;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Service;
import com.cognos.pogo.util.PogoLogger;
import java.util.Set;
import org.dom4j.Element;

public class ServiceStatusHandler
extends BasicHandler {
    private static final PogoLogger cat = PogoLogger.getLogger();
    protected static final String SUSPENDED = "suspended";
    protected static final String RUNNING = "running";
    protected static final String STOPPED = "suspended";
    protected static final String DISABLED = "disabled";
    protected static final String STANDBY = "standby";
    private String dispatcherStateHandlerName;
    private String serviceName;
    private String reporterName;
    private DispatcherStatusHandlerUpdateInterface dispatcherStateHandler;
    private SimpleRequestReportingHandler reporterHandler;
    private boolean registeredInCM = true;
    private PropagateStatus propagation;
    private RequestReporter requestReporterForTesting;

    public ServiceStatusHandler() {
        super(cat.getNativeLogger());
    }

    public String getDispatcherStateHandlerName() {
        return this.dispatcherStateHandlerName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.dispatcherStateHandlerName = config.attributeValue("dispatcherStateHandler");
        this.serviceName = config.attributeValue("serviceName");
        this.reporterName = config.attributeValue("reporterName");
        this.decodePropagation(config);
    }

    private void decodePropagation(Element config) {
        this.propagation = PropagateStatus.decodeValue(config.attributeValue("propagation"));
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.dispatcherStateHandler = (DispatcherStatusHandlerUpdateInterface)((Object)engine.lookupHandler(this.dispatcherStateHandlerName));
        if (this.dispatcherStateHandler == null) {
            Object[] args = new Object[]{this.dispatcherStateHandlerName};
            String errorMsg = DispatcherStrings.getInstance().getString("dispatcherStateHandlerNotFound", args);
            throw new PogoException(errorMsg);
        }
        this.checkForRegisteredInCM(engine);
        Service service = engine.getDispatcherServices().getService(this.serviceName);
        this.addDependentService(service);
        if (this.reporterName != null) {
            this.reporterHandler = (SimpleRequestReportingHandler)engine.lookupHandler(this.reporterName);
        }
    }

    void addDependentService(Service service) {
        if (this.registeredInCM) {
            this.dispatcherStateHandler.addDependentService(this.serviceName, service);
        }
    }

    void checkForRegisteredInCM(PogoEngine engine) {
        Set<String> installedComponents = engine.getInstalledComponents();
        if (!installedComponents.contains(this.serviceName)) {
            cat.debug("Ignoring service status updates for service: ", this.serviceName);
            this.registeredInCM = false;
        }
    }

    @Override
    public void configure(Configuration configuration) {
        if (this.propagation != null) {
            this.propagation.configure(configuration);
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    @Override
    public void start() {
        String status = RUNNING;
        if (this.getRequestReporter() != null) {
            status = this.getRequestReporter().getServiceStatus();
        }
        this.sendStateToDispatcher(status);
    }

    protected RequestReporter getRequestReporter() {
        if (this.requestReporterForTesting != null) {
            return this.requestReporterForTesting;
        }
        return this.reporterHandler == null ? null : this.reporterHandler.getRequestReporter();
    }

    @Override
    public void resume() {
        String status = RUNNING;
        if (this.getRequestReporter() != null) {
            status = this.getRequestReporter().getServiceStatus();
        }
        this.sendStateToDispatcher(status);
        this.propagateStatus();
    }

    @Override
    public void suspend(boolean immediate) {
        String status = "suspended";
        if (this.getRequestReporter() != null) {
            status = this.getRequestReporter().getServiceStatus();
        }
        this.sendStateToDispatcher(status);
        this.propagateStatus();
    }

    @Override
    public void stop() {
        this.sendStateToDispatcher("suspended");
        this.propagation.shutdown();
    }

    protected void sendStateToDispatcher(String state) {
        if (this.registeredInCM && this.dispatcherStateHandler != null && !state.equals(ServiceStatus.UNKNOWN)) {
            this.dispatcherStateHandler.setStatus(this.serviceName, state);
        }
    }

    protected void propagateStatus() {
        if (this.propagation != null) {
            this.propagation.propagateStatus();
        }
    }

    protected String getServiceStatusFor(String status) {
        return this.propagation != null ? this.propagation.getServiceStatusFor(status) : status;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    void setServiceNameForTest(String name) {
        this.serviceName = name;
    }

    void setDispatcherStateHandlerForTest(DispatcherStatusHandlerUpdateInterface statusHandler) {
        this.dispatcherStateHandler = statusHandler;
    }

    boolean isRegisteredInCM() {
        return this.registeredInCM;
    }

    void setRequestReporterForTesting(RequestReporter requestReporter) {
        this.requestReporterForTesting = requestReporter;
    }
}

