/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.logic;

import com.cognos.p2plb.clerver.balancer.OMBridgeHelper;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.DomUtils;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.internal.ombridge.BibusSoapAction;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class TableLookupHandler
extends BasicHandler {
    static final PogoLogger cat = PogoLogger.getLogger();
    private HashMap<String, String> lookupMap = new HashMap();
    private String keyName = null;
    private String resultName = null;
    private OMBridgeHelper bridgeHelper;

    public TableLookupHandler() {
        this(new OMBridgeHelper());
    }

    public TableLookupHandler(OMBridgeHelper bridgeHelper) {
        super(cat.getNativeLogger());
        this.bridgeHelper = bridgeHelper;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.keyName = this.getAttribute(cat, "keyName");
        this.resultName = this.getAttribute(cat, "resultName");
        boolean isSoapaction = this.keyName.endsWith(".soapaction");
        for (Element e : this.getLookupNodes()) {
            String from = e.attributeValue("from");
            String to = e.attributeValue("to");
            if (from != null && to != null) {
                cat.debug("adding lookup mapping from \"", from, "\" to \"", to, "\"");
                this.addMapping(from, to, isSoapaction);
                continue;
            }
            cat.error("Incorrect table lookup configuration for handler ", this.getName());
        }
    }

    private void addMapping(String from, String to, boolean isSoapaction) {
        BibusSoapAction action;
        if (isSoapaction && (action = new BibusSoapAction(from)).getFormat() == BibusSoapAction.Format.IBM && "*".equals(action.getVersion())) {
            this.addWildcardSoapActionMapping(action, to);
            return;
        }
        this.lookupMap.put(from, to);
    }

    private void addWildcardSoapActionMapping(BibusSoapAction action, String to) {
        for (String version : this.bridgeHelper.getSupportedVersions()) {
            action.setVersion(version);
            this.lookupMap.put(action.toString(), to);
        }
    }

    private List<Element> getLookupNodes() throws PogoException {
        try {
            return DomUtils.selectElements(this.getConfig(), "./lookup");
        }
        catch (Exception x) {
            cat.error("XPath problem", x);
            throw new PogoException("Handler config problem");
        }
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String key = (String)mc.getProperty(this.keyName);
        if (key == null) {
            cat.debug("key property ", this.keyName, " not found. ", this.resultName, " was not set.");
            return;
        }
        String result = this.lookupMap.get(key);
        if (result != null) {
            mc.setProperty(this.resultName, result);
            cat.debug("Lookup of ", this.keyName, "=", key, " yielded ", this.resultName, "=", result);
        }
    }

    String lookupMapping(String key) {
        return this.lookupMap.get(key);
    }
}

