/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.regulate;

import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Stopper {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(Stopper.class.getName());
    private static Stopper instance = new Stopper();
    boolean stopped = false;

    private Stopper() {
    }

    public static Stopper getInstance() {
        return instance;
    }

    public synchronized boolean check(long timeout) {
        if (!this.stopped) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        try {
            do {
                this.wait(timeout);
                if (this.stopped) continue;
                return true;
            } while (System.currentTimeMillis() - startTime <= timeout);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public synchronized void plug() {
        if (cat.isDebugEnabled()) {
            cat.debug("Stopper: Plug requests");
        }
        this.stopped = true;
    }

    public synchronized void unplug() {
        if (cat.isDebugEnabled()) {
            cat.debug("Stopper: Unplug requests");
        }
        this.stopped = false;
        this.notifyAll();
    }
}

