/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.systemservice;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.i18n.Collator;
import com.cognos.pogo.handlers.systemservice.SystemServiceTemplate;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.StringUtils;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class GetConfiguration
extends SystemServiceTemplate {
    private static final QName GET_CONFIGURATION_RESPONSE = DocumentHelper.createQName((String)"getConfigurationResponse", (Namespace)BIBusEnvelope.NS_BUS);
    private static final String BUS_LOCALE = BIBusEnvelope.NS_BUS.getPrefix() + ":locale";
    private static final String BUS_LOCALE_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":locale[]";
    private static final String BUS_LOCALE_MAP_ENTRY_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":localeMapEntry[]";
    private static final String BUS_TIMEZONE = BIBusEnvelope.NS_BUS.getPrefix() + ":timeZone";
    private static final String BUS_TIMEZONE_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":timeZone[]";
    private static final String BUS_CURRENCY = BIBusEnvelope.NS_BUS.getPrefix() + ":currency";
    private static final String BUS_CURRENCY_ARRAY = BIBusEnvelope.NS_BUS.getPrefix() + ":currency[]";

    private void transferNamespaceDeclarations(Element sourceElement, Element targetElement) {
        Iterator it = sourceElement.nodeIterator();
        while (it.hasNext()) {
            Node childNode = (Node)it.next();
            if (!(childNode instanceof Namespace)) continue;
            targetElement.add((Node)childNode.clone());
        }
    }

    private void populateContentLocaleMap(Element configurationElement, Collection<String> requestedProperties, Element localeExport) {
        Element contentLocaleMapElement = configurationElement.addElement("contentLocaleMap");
        contentLocaleMapElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        contentLocaleMapElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_LOCALE_MAP_ENTRY_ARRAY);
        if (!requestedProperties.contains("contentLocaleMap")) {
            return;
        }
        this.transferNamespaceDeclarations(localeExport, contentLocaleMapElement);
        Element exportContentLocaleMapElement = localeExport.element("contentLocaleMap").element("value");
        ListIterator it = exportContentLocaleMapElement.elements().listIterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            item.detach();
            contentLocaleMapElement.add(item);
        }
    }

    private void populateProductLocaleMap(Element configurationElement, Collection<String> requestedProperties, Element localeExport) {
        Element productLocaleMapElement = configurationElement.addElement("productLocaleMap");
        productLocaleMapElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        productLocaleMapElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_LOCALE_MAP_ENTRY_ARRAY);
        if (!requestedProperties.contains("productLocaleMap")) {
            return;
        }
        this.transferNamespaceDeclarations(localeExport, productLocaleMapElement);
        Element exportProductLocaleMapElement = localeExport.element("productLocaleMap").element("value");
        ListIterator it = exportProductLocaleMapElement.elements().listIterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            item.detach();
            productLocaleMapElement.add(item);
        }
    }

    private void populateServerLocale(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element serverLocaleElement = configurationElement.addElement("serverLocale");
        serverLocaleElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        serverLocaleElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_LOCALE_ARRAY);
        if (!requestedProperties.contains("serverLocale")) {
            return;
        }
        String serverLocaleID = cclConfiguration.getValue("serverLocale", true);
        Map productLocaleMap = cclConfiguration.getProductLocaleList(userProductLocale);
        serverLocaleElement.add(this.createLocaleElement(serverLocaleID, (String)productLocaleMap.get(serverLocaleID)));
    }

    private void populateServerTimeZone(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element serverTimeZoneElement = configurationElement.addElement("serverTimeZone");
        serverTimeZoneElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        serverTimeZoneElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_TIMEZONE_ARRAY);
        if (!requestedProperties.contains("serverTimeZone")) {
            return;
        }
        String timeZoneID = cclConfiguration.getValue("serverTimeZoneID", true);
        Map timeZonesMap = cclConfiguration.getTimeZones(userProductLocale);
        serverTimeZoneElement.add(this.createTimeZoneElement(timeZoneID, (String)timeZonesMap.get(timeZoneID)));
    }

    private Element createTimeZoneElement(String id, String name) {
        Element itemElement = DocumentHelper.createElement((String)"item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_TIMEZONE);
        Element idElement = itemElement.addElement("id");
        idElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        idElement.setText(id);
        Element nameElement = itemElement.addElement("name");
        nameElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        nameElement.setText(name);
        return itemElement;
    }

    private Element createLocaleElement(String locale, String description) {
        Element itemElement = DocumentHelper.createElement((String)"item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_LOCALE);
        Element localeIDElement = itemElement.addElement("locale");
        localeIDElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        localeIDElement.setText(locale);
        Element descriptionElement = itemElement.addElement("description");
        descriptionElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        descriptionElement.setText(description);
        return itemElement;
    }

    private Element createCurrencyElement(String currency, String description) {
        Element itemElement = DocumentHelper.createElement((String)"item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, BUS_CURRENCY);
        Element currencyElement = itemElement.addElement("currency");
        currencyElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        currencyElement.setText(currency);
        Element descriptionElement = itemElement.addElement("description");
        descriptionElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        descriptionElement.setText(description);
        return itemElement;
    }

    @Override
    SOAPEnvelope performOperation(Element operationElement, ICCLConfiguration cclConfiguration, BIBusEnvelope requestEnvelope) throws Exception {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        Element getConfigurationResponseElement = responseEnvelope.getBody().addElement(GET_CONFIGURATION_RESPONSE);
        String userProductLocale = requestEnvelope.getUserPreferenceValue("productLocale");
        Element configurationElement = this.addResultElement(getConfigurationResponseElement);
        configurationElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":configurationData");
        Collection<String> requestedProperties = this.collectPropertySelections(operationElement.element("properties"));
        Element localeExport = null;
        if (requestedProperties.contains("contentLocaleMap") || requestedProperties.contains("productLocaleMap")) {
            String configurationData = cclConfiguration.export();
            StringReader reader = new StringReader(configurationData);
            BIBusEnvelope configDataEnvelope = new BIBusEnvelope(reader);
            localeExport = configDataEnvelope.getAsDocument().getRootElement();
        }
        this.populateContentLocaleMap(configurationElement, requestedProperties, localeExport);
        this.populateDefaultFont(configurationElement, requestedProperties, cclConfiguration);
        this.populateProductLocaleMap(configurationElement, requestedProperties, localeExport);
        this.populateServerLocale(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateServerTimeZone(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateSupportedProductLocales(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateSupportedContentLocales(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateTimeZones(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateSupportedFonts(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateSupportedCurrencies(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateMetadataInformationURI(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        this.populateGlossaryURI(configurationElement, requestedProperties, cclConfiguration, userProductLocale);
        return responseEnvelope;
    }

    Element addResultElement(Element getConfigurationResponseElement) {
        return getConfigurationResponseElement.addElement("configuration");
    }

    private void populateSupportedCurrencies(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element supportedCurrenciesElement = configurationElement.addElement("supportedCurrencies");
        supportedCurrenciesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        supportedCurrenciesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_CURRENCY_ARRAY);
        if (!requestedProperties.contains("supportedCurrencies")) {
            return;
        }
        Map currenciesMap = cclConfiguration.getCurrencies(userProductLocale);
        for (Map.Entry entry : currenciesMap.entrySet()) {
            Element currencyElement = this.createCurrencyElement((String)entry.getKey(), (String)entry.getValue());
            supportedCurrenciesElement.add(currencyElement);
        }
    }

    private void populateTimeZones(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element timeZonesElement = configurationElement.addElement("timeZones");
        timeZonesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        timeZonesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_TIMEZONE_ARRAY);
        if (!requestedProperties.contains("timeZones")) {
            return;
        }
        Map timeZonesMap = cclConfiguration.getTimeZones(userProductLocale);
        for (Map.Entry entry : timeZonesMap.entrySet()) {
            Element timeZoneElement = this.createTimeZoneElement((String)entry.getKey(), (String)entry.getValue());
            timeZonesElement.add(timeZoneElement);
        }
    }

    private void populateSupportedContentLocales(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element supportedContentLocalesElement = configurationElement.addElement("supportedContentLocales");
        supportedContentLocalesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        supportedContentLocalesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_LOCALE_ARRAY);
        if (!requestedProperties.contains("supportedContentLocales")) {
            return;
        }
        Map supportedContentLocales = cclConfiguration.getContentLocaleList(userProductLocale);
        Iterator keyIterator = supportedContentLocales.entrySet().iterator();
        TreeMap sorted = new TreeMap(new MyCollator(StringUtils.getLocale(userProductLocale)));
        while (keyIterator.hasNext()) {
            Map.Entry entry = keyIterator.next();
            sorted.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : sorted.entrySet()) {
            Element localeElement = this.createLocaleElement((String)entry.getValue(), (String)entry.getKey());
            supportedContentLocalesElement.add(localeElement);
        }
    }

    private void populateSupportedProductLocales(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element supportedProductLocalesElement = configurationElement.addElement("supportedProductLocales");
        supportedProductLocalesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        supportedProductLocalesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, BUS_LOCALE_ARRAY);
        if (!requestedProperties.contains("supportedProductLocales")) {
            return;
        }
        Map supportedProductLocales = cclConfiguration.getProductLocaleList(userProductLocale);
        Iterator keyIterator = supportedProductLocales.entrySet().iterator();
        TreeMap sorted = new TreeMap(new MyCollator(StringUtils.getLocale(userProductLocale)));
        while (keyIterator.hasNext()) {
            Map.Entry entry = keyIterator.next();
            sorted.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : sorted.entrySet()) {
            Element localeElement = this.createLocaleElement((String)entry.getValue(), (String)entry.getKey());
            supportedProductLocalesElement.add(localeElement);
        }
    }

    private void populateDefaultFont(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration) throws Exception {
        Element defaultFontElement = configurationElement.addElement("defaultFont");
        defaultFontElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        defaultFontElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, SOAPEnvelope.XSD_STRING + "[]");
        if (!requestedProperties.contains("defaultFont")) {
            return;
        }
        String theDefaultFont = cclConfiguration.getValue("defaultFont", false);
        Element itemElement = defaultFontElement.addElement("item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        itemElement.setText(theDefaultFont);
    }

    private void populateSupportedFonts(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element defaultFontElement = configurationElement.addElement("supportedFonts");
        defaultFontElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        defaultFontElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, SOAPEnvelope.XSD_STRING + "[]");
        if (!requestedProperties.contains("supportedFonts")) {
            return;
        }
        List fontList = cclConfiguration.getFonts(userProductLocale);
        for (String aFont : fontList) {
            Element itemElement = defaultFontElement.addElement("item");
            itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
            itemElement.setText(aFont);
        }
    }

    private void populateMetadataInformationURI(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element defaultUriElement = configurationElement.addElement("metadataInformationURI");
        defaultUriElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        defaultUriElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, SOAPEnvelope.XSD_STRING + "[]");
        if (!requestedProperties.contains("metadataInformationURI")) {
            return;
        }
        String metaddataURI = cclConfiguration.getValue("metadataInformationURI", false);
        Element itemElement = defaultUriElement.addElement("item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        itemElement.setText(metaddataURI);
    }

    private void populateGlossaryURI(Element configurationElement, Collection<String> requestedProperties, ICCLConfiguration cclConfiguration, String userProductLocale) throws Exception {
        Element defaultUriElement = configurationElement.addElement("glossaryURI");
        defaultUriElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        defaultUriElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, SOAPEnvelope.XSD_STRING + "[]");
        if (!requestedProperties.contains("glossaryURI")) {
            return;
        }
        String glossaryURI = cclConfiguration.getValue("glossaryURI", false);
        Element itemElement = defaultUriElement.addElement("item");
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        itemElement.setText(glossaryURI);
    }

    private Collection<String> collectPropertySelections(Element propertiesEnumeration) throws Exception {
        HashSet<String> selections = new HashSet<String>();
        Iterator itemsIterator = propertiesEnumeration.elementIterator();
        while (itemsIterator.hasNext()) {
            Element itemElement = (Element)itemsIterator.next();
            String enumerationString = itemElement.getText();
            if (enumerationString == null || "".equals(enumerationString)) continue;
            selections.add(enumerationString);
        }
        return selections;
    }

    private static class MyCollator
    extends Collator {
        public MyCollator(Locale locale) {
            super(locale);
        }

        public int compare(Object source, Object target) {
            return this.collator.compare((String)source, (String)target);
        }
    }
}

