/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.systemservice;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.handlers.systemservice.SystemServiceTemplate;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class GetFormatSamples
extends SystemServiceTemplate {
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(GetFormatSamples.class.getName());
    private static final QName GET_FORMAT_SAMPLES_RESPONSE = DocumentHelper.createQName((String)"getFormatSamplesResponse", (Namespace)BIBusEnvelope.NS_BUS);
    private Element formatConfiguration;

    private synchronized Element getFormatConfiguration(ICCLConfiguration configuration) throws Exception {
        if (this.formatConfiguration != null) {
            return this.formatConfiguration;
        }
        String formatSpecificationFileName = configuration.getValue("formatSpecificationLocation", true);
        String fullPath = configuration.resolveEffectivePath(formatSpecificationFileName);
        logger.debug("formatSpecificationLocation -> " + fullPath);
        SAXReader reader = new SAXReader();
        Document formatSamplesDocument = reader.read(new File(fullPath));
        this.formatConfiguration = formatSamplesDocument.getRootElement();
        return this.formatConfiguration;
    }

    private Element getFormatList(ICCLConfiguration cclConfig, String name, String locale, String mappedLocale) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Getting formatList " + name + " for locale " + locale);
        }
        Element formatConfig = this.getFormatConfiguration(cclConfig);
        Element normalizedFormatList = null;
        Iterator it = formatConfig.elementIterator("formatList");
        while (it.hasNext()) {
            Element formatList = (Element)it.next();
            Attribute nameAttribute = formatList.attribute("name");
            if (logger.isDebugEnabled()) {
                logger.debug("Matching name against list -> " + nameAttribute.getValue());
            }
            if (!name.equalsIgnoreCase(nameAttribute.getValue())) continue;
            Attribute localeAttribute = formatList.attribute("lang");
            if (logger.isDebugEnabled() && localeAttribute != null) {
                logger.debug("Matching locale language -> " + localeAttribute.getValue());
            }
            if (localeAttribute == null || locale.equalsIgnoreCase(localeAttribute.getValue())) {
                logger.debug("Found matching format list");
                return formatList;
            }
            if (!mappedLocale.equalsIgnoreCase(localeAttribute.getValue())) continue;
            normalizedFormatList = formatList;
        }
        if (normalizedFormatList == null) {
            logger.debug("No format list matched");
        } else {
            logger.debug("Format list matched against normalized locale");
        }
        return normalizedFormatList;
    }

    private String getAsString(Element anElement) throws Exception {
        StringWriter strWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)strWriter);
        writer.write(anElement);
        writer.flush();
        return strWriter.toString();
    }

    private Element createItemElement(Element formatElement) throws Exception {
        return this.createItemElement(formatElement, SOAPEnvelope.XSD_STRING);
    }

    protected Element createItemElement(Element formatElement, String itemType) throws Exception {
        Element item = DocumentHelper.createElement((String)"item");
        item.addAttribute(SOAPEnvelope.XSI_TYPE, itemType);
        item.setText(this.getAsString(formatElement));
        return item;
    }

    @Override
    SOAPEnvelope performOperation(Element operationElement, ICCLConfiguration cclConfiguration, BIBusEnvelope requestEnvelope) throws Exception {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        Element getFormatSamplesResponseElement = responseEnvelope.getBody().addElement(GET_FORMAT_SAMPLES_RESPONSE);
        Element samplesElement = this.createSamplesElement(getFormatSamplesResponseElement);
        Element namePropertyElement = operationElement.element("name");
        String nameProperty = namePropertyElement.getTextTrim();
        logger.debug("Processing getFormatSamples request for format list: " + nameProperty);
        String productLocale = null;
        String contentLocale = requestEnvelope.getUserPreferenceValue("contentLocale");
        Element formatListElement = null;
        if (contentLocale != null) {
            formatListElement = this.getFormatList(cclConfiguration, nameProperty, contentLocale, cclConfiguration.mapContentLocale(contentLocale, true));
        }
        if (formatListElement == null && (productLocale = requestEnvelope.getUserPreferenceValue("productLocale")) != null) {
            formatListElement = this.getFormatList(cclConfiguration, nameProperty, productLocale, cclConfiguration.mapProductLocale(productLocale, true));
        }
        if (formatListElement == null) {
            if (productLocale == null && contentLocale == null) {
                throw new Exception(DispatcherStrings.getInstance().getString("GetFormatSamples.noLocale"));
            }
            return responseEnvelope;
        }
        Iterator it = formatListElement.elementIterator();
        while (it.hasNext()) {
            Element formatElement = (Element)it.next();
            this.addToSamplesElement(samplesElement, formatElement);
        }
        return responseEnvelope;
    }

    Element createSamplesElement(Element getFormatSamplesResponseElement) {
        Element samplesElement = getFormatSamplesResponseElement.addElement("samples");
        samplesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        samplesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, SOAPEnvelope.XSD_STRING + "[]");
        return samplesElement;
    }

    void addToSamplesElement(Element samplesElement, Element formatElement) throws Exception {
        samplesElement.add(this.createItemElement(formatElement));
    }

    @Override
    synchronized void reconfigure(ICCLConfiguration cclConfiguration) {
        try {
            cclConfiguration.getValue("formatSpecificationLocation", true);
        }
        catch (CCLConfigurationException ex) {
            logger.warn("Failed to retrieve 'formatSpecificationLocation'", (Throwable)ex);
            return;
        }
    }
}

