/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.tracking;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PrepareConversationContextHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(PrepareConversationContextHandler.class.getName());

    public PrepareConversationContextHandler() {
        super(logger);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String soapAction = (String)mc.getProperty("request.soapaction");
        RequestAffinity affinity = RequestAffinity.determineAffinity(soapAction);
        if (affinity.isProcessSpecific()) {
            logger.debug("request is absolute or control affinity, leave it alone.");
            return;
        }
        BIBusEnvelope reqEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        String id = reqEnv.getConversationContextID();
        if (id != null && id.length() > 0) {
            logger.debug("conversation context id is set already, so do not prepare conversation context.");
            return;
        }
        logger.debug("preparing the conversation context.");
        mc.setProperty("PrepareConversationContextHandler.prepared", Boolean.TRUE);
        reqEnv.setConversationContextID(reqEnv.getTrackingRequestContext());
        String nodeId = reqEnv.getConversationContextNodeID();
        if (nodeId == null || nodeId.length() == 0) {
            reqEnv.setConversationContextNodeID(NodeID.getSelf().getGuid());
        }
        reqEnv.setConversationContextProcessID(-1);
        reqEnv.setConversationContextAffinityStrength(0);
    }
}

