/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.tracking;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ValidateResponseConversationContextHandler
extends BasicHandler {
    static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(ValidateResponseConversationContextHandler.class.getName());
    private boolean validateProcessID;
    private boolean validateAffinityStrength;

    public ValidateResponseConversationContextHandler() {
        super(logger);
    }

    public boolean getValidateProcessID() {
        return this.validateProcessID;
    }

    public boolean getValidateAffinityStrength() {
        return this.validateAffinityStrength;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        String s = this.getRequiredAttribute(logger, "validateProcessID");
        this.validateProcessID = Boolean.valueOf(s);
        s = this.getRequiredAttribute(logger, "validateAffinityStrength");
        this.validateAffinityStrength = Boolean.valueOf(s);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        int affinityStrength;
        int processID;
        String nodeID;
        BIBusEnvelope responseEnv = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        String status = responseEnv.getConversationContextStatus();
        if ("conversationComplete".equals(status)) {
            logger.debug("conversation is complete, so don't do any additional checks on the conversation context.");
            return;
        }
        boolean foundIssue = false;
        if (status == null || status.length() == 0) {
            foundIssue = true;
            logger.warn("response does not contain conversation context status");
        } else if (logger.isDebugEnabled()) {
            logger.debug("response status is\"" + status + "\"");
        }
        String id = responseEnv.getConversationContextID();
        if (id == null || id.length() == 0) {
            foundIssue = true;
            logger.warn("response does not contain conversation id.");
        }
        if ((nodeID = responseEnv.getConversationContextNodeID()) == null || nodeID.length() == 0) {
            foundIssue = true;
            logger.warn("response does not contain conversation node id.");
        }
        if (this.validateProcessID && (processID = responseEnv.getConversationContextProcessID()) < 0) {
            logger.warn("response does not contain valid conversation process id.");
        }
        if (this.validateAffinityStrength && (affinityStrength = responseEnv.getConversationContextAffinityStrength()) < 0) {
            foundIssue = true;
            logger.warn("response does not contain valid conversation affinity strength.");
        }
        if (foundIssue && logger.isWarnEnabled()) {
            StringWriter strWriter = new StringWriter();
            BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            try {
                requestEnvelope.writeAsXML(strWriter);
                logger.warn("Request envelope: ");
                logger.warn(strWriter.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            strWriter = new StringWriter();
            try {
                responseEnv.writeAsXML(strWriter);
                logger.warn("Response envelope: ");
                logger.warn(strWriter.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

