/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.util;

import com.cognos.pogo.bibus.SOAPAction;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ExecuteLocallyHandler
extends BasicHandler {
    static final PogoLogger log = PogoLogger.getLogger();
    private String affinity;
    private String targetAffinity;

    public ExecuteLocallyHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.affinity = config.attributeValue("sourceAffinity");
        this.targetAffinity = config.attributeValue("targetAffinity");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String reqSoapAction = mc.getStrProperty("request.soapaction");
        SOAPAction soapAction = new SOAPAction(reqSoapAction);
        if (StringUtils.equals((String)this.affinity, (String)soapAction.getSuffix())) {
            soapAction.setSuffix(this.targetAffinity);
            String targetSoapAction = soapAction.getComplete();
            mc.setProperty("request.soapaction", targetSoapAction);
            log.debug("Mapped soap action from ", reqSoapAction, " to ", targetSoapAction);
        }
    }
}

