/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.util;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.config.DispatcherListService;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class WriteConfigurationToFileHandler
extends BasicHandler {
    private static PogoLogger log = PogoLogger.getLogger();
    private String path;
    private String globalPropPath;
    private String serverListName;
    private String isSecureName;
    private String serviceName;
    private TreeSet<String> blacklist = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    static String[] globalParameters = new String[]{"contentManager"};
    static ArrayList<String> globalPropList = new ArrayList<String>(Arrays.asList(globalParameters));
    static String DISP_PROP_PATH = "../configuration/dispatcher.properties";
    static String DISP_GLOBAL_PROP_PATH = "../configuration/dispatcher_global.properties";

    public WriteConfigurationToFileHandler() {
        this(WriteConfigurationToFileHandler.resolvePath(DISP_PROP_PATH));
    }

    public WriteConfigurationToFileHandler(String path) {
        super(log.getNativeLogger());
        this.path = path;
        this.globalPropPath = WriteConfigurationToFileHandler.resolvePath(DISP_GLOBAL_PROP_PATH);
    }

    private static String resolvePath(String relPath) {
        return CCLConfigurationUtils.resolveEffectivePath((String)relPath);
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.serverListName = this.getOptionalAttribute("serverList");
        this.isSecureName = this.getOptionalAttribute("isSecure");
        this.serviceName = this.getOptionalAttribute("serviceName");
        String blacklistString = this.getOptionalAttribute("serviceBlacklist");
        this.setBlacklist(blacklistString);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
    }

    @Override
    public void configure(Configuration configuration) {
        Properties properties = new Properties();
        Properties globalProperties = new Properties();
        ICCLConfiguration icclConfiguration = configuration.getICCLConfiguration();
        try {
            Collection<String> parameterNames = this.clone(icclConfiguration.getParameterNames());
            for (String name : parameterNames) {
                properties.setProperty(name, configuration.getValue(name));
                if (globalPropList == null || !globalPropList.contains(name)) continue;
                globalProperties.setProperty(name, configuration.getValue(name));
            }
            this.addServerList(properties, configuration);
            WriteConfigurationToFileHandler.writeConfigurationToFile(properties, this.path);
            WriteConfigurationToFileHandler.writeConfigurationToFile(globalProperties, this.globalPropPath);
        }
        catch (CCLConfigurationException e1) {
            log.debug("Unable to output complete configuration", e1);
        }
    }

    private Collection<String> clone(Collection<String> parameterNames) {
        return new HashSet<String>(parameterNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeConfigurationToFile(Properties properties, String fileName) {
        File tmpFile = new File(fileName + ".tmp");
        File optFile = new File(fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tmpFile);
            properties.store(out, "");
            IOUtils.closeQuietly((OutputStream)out);
            out = null;
            log.debug("Wrote configuration to: ", tmpFile);
            Files.move(tmpFile.toPath(), optFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            log.debug("replaced configuration file: ", fileName);
        }
        catch (Exception e) {
            try {
                log.error("Exception when updating configuration file '" + fileName + "' - ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private void addServerList(Properties properties, Configuration configuration) {
        StringJoiner joiner = new StringJoiner(",");
        boolean isSecure = false;
        DispatcherList dispatcherList = (DispatcherList)configuration.getDispatcherList();
        for (DispatcherListElement dle : dispatcherList.getDispatcherListElements()) {
            if (!this.hasService(dle) || !this.notInBlacklist(dle)) continue;
            String hostPort = (dle.isSslEnabled() ? "https" : "http") + "://" + dle.getName().split("/")[0] + ";" + this.encode(dle.getServerGroup()) + ";" + dle.getCapacityAsDouble();
            joiner.add(hostPort);
            isSecure |= dle.isSslEnabled();
        }
        properties.put(this.serverListName, joiner.toString());
        properties.put(this.isSecureName, Boolean.toString(isSecure));
        log.info("addServerList() - update with " + this.serverListName + "=" + joiner.toString() + "\n");
    }

    private String encode(String grpname) {
        return Base64.getEncoder().encodeToString(grpname.getBytes());
    }

    private boolean hasService(DispatcherListElement dle) {
        if (StringUtils.isEmpty((String)this.serviceName)) {
            return true;
        }
        Iterator<DispatcherListService> itSrvc = dle.iterator();
        while (itSrvc.hasNext()) {
            DispatcherListService srvc = itSrvc.next();
            String thisServiceName = srvc.getName();
            if (!thisServiceName.equals(this.serviceName)) continue;
            return true;
        }
        return false;
    }

    private boolean notInBlacklist(DispatcherListElement dle) {
        if (this.blacklist.size() == 0) {
            return true;
        }
        Iterator<DispatcherListService> itSrvc = dle.iterator();
        while (itSrvc.hasNext()) {
            DispatcherListService srvc = itSrvc.next();
            String thisServiceName = srvc.getName();
            if (!this.blacklist.contains(thisServiceName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    void setBlacklist(String blacklistString) {
        if (blacklistString != null) {
            this.blacklist.addAll(Arrays.asList(blacklistString.split(",")));
        }
    }

    public static class JMXDispatcherFactory {
        public JMXDispatcher createJmxDispatcher(DispatcherListElement dle) {
            return new JMXDispatcher(dle);
        }
    }
}

