/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.handlers.xts;

import com.cognos.pogo.handlers.xts.XtsRequestFactory;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class Dom4jXtsRequestFactory
extends XtsRequestFactory {
    private static final Namespace NS_XTS_FAULT = Namespace.get((String)"fault", (String)"http://developer.cognos.com/schemas/xts/portal/iFaultHandler/1/");
    private static QName qn_xts_handleFault = new QName("handleFault", NS_XTS_FAULT);
    private static QName qn_xts_prompt = new QName("prompt", NS_XTS_FAULT);
    private static QName qn_xts_fault = new QName("fault", NS_XTS_FAULT);
    private static QName qn_xts_originalRequest = new QName("originalRequest", NS_XTS_FAULT);
    private static QName qn_xts_option = new QName("option", NS_XTS_FAULT);

    @Override
    protected SOAPEnvelope createXtsEnvelope(SOAPEnvelope biBusHeaderSource) {
        return new BIBusEnvelope(biBusHeaderSource.getHeader().createCopy());
    }

    @Override
    protected void addBodyFault(SOAPEnvelope xtsEnvelope, SOAPEnvelope faultEnvelope, SOAPEnvelope originalRequest) {
        Element bodyFault = this.createBodyFault(xtsEnvelope, faultEnvelope);
        bodyFault.addElement(qn_xts_fault).add(faultEnvelope.getEnvelope().createCopy());
        bodyFault.addElement(qn_xts_originalRequest).add(originalRequest.getEnvelope().createCopy());
        this.addBackButtonOption(bodyFault);
    }

    private Element createBodyFault(SOAPEnvelope xtsEnvelope, SOAPEnvelope faultResponse) {
        Element biBusHeader = faultResponse.getHeader().element("biBusHeader");
        Boolean isPrompt = biBusHeader.element("Prompt") != null || ((BIBusEnvelope)faultResponse).getFormValue("pps_promptfault") == "true";
        QName qname = isPrompt != false ? qn_xts_prompt : qn_xts_handleFault;
        return xtsEnvelope.getBody().addElement(qname);
    }

    private void addBackButtonOption(Element bodyFault) {
        Element backButtonOption = bodyFault.addElement(qn_xts_option).addElement("param");
        backButtonOption.addAttribute("name", "backButton");
        backButtonOption.addText("false");
    }
}

