/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.httpclient;

import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.http.httpclient.RawHttpMethod;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;

public class RawPostMethod
extends HttpMethodBase
implements RawHttpMethod {
    private int requestContentLength = -1;
    private MsgBodyGenerator requestBodyGenerator = null;

    public RawPostMethod() {
    }

    public RawPostMethod(String requestPath) {
        super(requestPath);
    }

    public String getName() {
        return "POST";
    }

    @Deprecated
    public void recycle() {
        super.recycle();
        this.requestContentLength = -1;
    }

    @Override
    public void setRequestBodyGenerator(MsgBodyGenerator requestBodySource) {
        this.requestBodyGenerator = requestBodySource;
    }

    MsgBodyGenerator getRequestBodyGenerator() {
        return this.requestBodyGenerator;
    }

    protected int getRequestContentLength() {
        return this.requestContentLength;
    }

    @Override
    public void setRequestContentLength(int length) {
        this.requestContentLength = length;
    }

    public byte[] getResponseBody() {
        throw new UnsupportedOperationException();
    }

    public String getResponseBodyAsString() {
        throw new UnsupportedOperationException();
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestContentLength() == -1) {
            ChunkedOutputStream os = new ChunkedOutputStream(conn.getRequestOutputStream());
            this.requestBodyGenerator.writeBody((OutputStream)os);
            os.close();
        } else {
            OutputStream os = conn.getRequestOutputStream();
            this.requestBodyGenerator.writeBody(os);
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.requestBodyGenerator.rewind()) {
            RawPostMethod clonedMethod = new RawPostMethod();
            clonedMethod.setRequestBodyGenerator(this.getRequestBodyGenerator());
            clonedMethod.setPath(this.getPath());
            Header[] headers = this.getRequestHeaders();
            for (int i = 0; i < headers.length; ++i) {
                clonedMethod.addRequestHeader(headers[i]);
            }
            clonedMethod.requestContentLength = this.requestContentLength;
            return clonedMethod;
        }
        throw new CloneNotSupportedException();
    }
}

