/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.mime;

public class BoyerMooreTextSearch {
    private static final int MAXCHAR = 256;
    private byte[] pat;
    private int patLen;
    private int partial;
    private int[] skip = new int[256];
    private int[] d = null;

    public void compile(String pattern) {
        this.compile(pattern.getBytes());
    }

    public void compile(byte[] patternBytes) {
        int j;
        int k;
        this.pat = patternBytes;
        this.patLen = this.pat.length;
        int[] f = new int[this.patLen];
        this.d = new int[this.patLen];
        int m = this.patLen;
        for (k = 0; k < 256; ++k) {
            this.skip[k] = m;
        }
        for (k = 1; k <= m; ++k) {
            this.d[k - 1] = (m << 1) - k;
            this.skip[this.pat[k - 1]] = m - k;
        }
        int t = m + 1;
        for (j = m; j > 0; --j) {
            f[j - 1] = t;
            while (t <= m && this.pat[j - 1] != this.pat[t - 1]) {
                this.d[t - 1] = this.d[t - 1] < m - j ? this.d[t - 1] : m - j;
                t = f[t - 1];
            }
            --t;
        }
        int q = t;
        t = m + 1 - q;
        int q1 = 1;
        int t1 = 0;
        for (j = 1; j <= t; ++j) {
            f[j - 1] = t1;
            while (t1 >= 1 && this.pat[j - 1] != this.pat[t1 - 1]) {
                t1 = f[t1 - 1];
            }
            ++t1;
        }
        while (q < m) {
            for (k = q1; k <= q; ++k) {
                this.d[k - 1] = this.d[k - 1] < m + q - k ? this.d[k - 1] : m + q - k;
            }
            q1 = q + 1;
            q = q + t - f[t - 1];
            t = f[t - 1];
        }
    }

    public int search(byte[] text, int start, int length) {
        int k;
        int textLen = length + start;
        this.partial = -1;
        if (this.d == null) {
            return -1;
        }
        int m = this.patLen;
        if (m == 0) {
            return 0;
        }
        int j = 0;
        int max = 0;
        for (k = start + m - 1; k < textLen; k += max) {
            for (j = m - 1; j >= 0 && text[k] == this.pat[j]; --j) {
                --k;
            }
            if (j == -1) {
                return k + 1;
            }
            int z = this.skip[text[k] & 0xFF];
            max = z > this.d[j] ? z : this.d[j];
        }
        if (k >= textLen && j > 0) {
            this.partial = k - max - 1;
            return -1;
        }
        return -1;
    }

    public int partialMatch() {
        return this.partial;
    }
}

