/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.http.mime;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.http.mime.BoyerMooreTextSearch;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;

public class MimeParseInputStream
extends InputStream {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final int BOUNDARY_REACHED = -1;
    private static final int BUFFER_LIMIT_REACHED = -2;
    static final String FAST_STREAM_READ_PROPERTY = "MimeParseInputStream.FastStreamRead.enabled";
    static final String FAST_STREAM_READ_DEFAULT = "true";
    static Boolean isFastStreamReadEnabled;
    static final String RESPONSE_BUFFER_SIZE_PROPERTY = "MimeParseInputStream.ResponseBufferSize";
    static final String RESPONSE_BUFFER_SIZE_DEFAULT = "32768";
    static Integer responseBufferSize;
    private InputStream upstream;
    private BoyerMooreTextSearch searcher;
    private byte[] boundary;
    private byte[] buffer = MimeParseInputStream.createResponseBuffer();
    private int iTake;
    private int iEnd;
    private int iTakeLimit;
    private int iBoundaryPosition;
    private boolean bAtPartEnd;
    private boolean bExhausted;
    private int totalByteReadCount;
    boolean hasNextCalled;
    boolean hasMore;
    private int iBoundaryAdjustment;
    private static int crnl_length;

    public static byte[] createResponseBuffer() {
        return new byte[MimeParseInputStream.getResponseBufferSize()];
    }

    private static int getResponseBufferSize() {
        if (responseBufferSize == null) {
            responseBufferSize = MimeParseInputStream.getResponseBufferSizeProperty();
        }
        return responseBufferSize;
    }

    private static Integer getResponseBufferSizeProperty() {
        String propertyValue = PropertyInserter.getProperty(RESPONSE_BUFFER_SIZE_PROPERTY, RESPONSE_BUFFER_SIZE_DEFAULT);
        int bufferSize = MimeParseInputStream.parseBufferSize(propertyValue);
        log.info(RESPONSE_BUFFER_SIZE_PROPERTY, "=", bufferSize);
        return bufferSize;
    }

    private static int parseBufferSize(String propertyValue) {
        try {
            return Integer.valueOf(propertyValue);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value assigned to property ", RESPONSE_BUFFER_SIZE_PROPERTY, ": [", propertyValue, "]. Using default.");
            return Integer.valueOf(RESPONSE_BUFFER_SIZE_DEFAULT);
        }
    }

    MimeParseInputStream(InputStream is, byte[] boundary) throws IOException {
        try {
            this.initializeFields();
            this.upstream = is;
            this.boundary = boundary;
            this.searcher = new BoyerMooreTextSearch();
            this.searcher.compile(boundary);
            this.fillBuffer(boundary.length + 2);
            this.searchBoundary();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            log.warn("MimeParseInputStream constructor threw an exception", ex);
            throw new IOException();
        }
    }

    private void initializeFields() {
        this.iTake = 0;
        this.iEnd = 0;
        this.iTakeLimit = 0;
        this.iBoundaryPosition = -1;
        this.bAtPartEnd = false;
        this.bExhausted = false;
        this.totalByteReadCount = 0;
        this.hasNextCalled = false;
        this.hasMore = false;
        this.iBoundaryAdjustment = 0;
    }

    private void logSnapShot(String msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg, " iTake=", this.iTake, " iTakeLimit=", this.iTakeLimit, " iEnd=", this.iEnd, " iBoundaryPosition=", this.iBoundaryPosition, " totalByteReadCount=", this.totalByteReadCount);
        }
    }

    private void fillBuffer(int bytesNeeded) throws IOException {
        this.logFillBuffer(bytesNeeded);
        if (this.iTake > 0) {
            System.arraycopy(this.buffer, this.iTake, this.buffer, 0, this.iEnd - this.iTake);
            this.iEnd -= this.iTake;
            this.iTakeLimit -= this.iTake;
            this.iTake = 0;
        }
        int byteReadCount = 0;
        while (this.iEnd < bytesNeeded) {
            int bytesRead = this.readFromUpstream(this.buffer, this.iEnd, this.buffer.length - this.iEnd);
            log.debug("read ", bytesRead, " bytes from upstream");
            if (bytesRead < 0) {
                throw new IOException("MSG_TRUNCATED");
            }
            this.iEnd += bytesRead;
            byteReadCount += bytesRead;
        }
        log.debug("fillBuffer bytes read=", byteReadCount);
    }

    private void logFillBuffer(int bytesNeeded) {
        if (log.isDebugEnabled()) {
            log.debug("fillBuffer( bytesNeeded=", bytesNeeded, ")");
            if (this.iTake > 0) {
                log.debug("fillBuffer() - preserve ", this.iEnd - this.iTake, " bytes");
            }
        }
    }

    private void searchBoundary() {
        this.iBoundaryPosition = this.searcher.search(this.buffer, this.iTake, this.iEnd - this.iTake);
        if (this.iBoundaryPosition != -1) {
            if (this.iBoundaryPosition <= crnl_length) {
                this.iBoundaryAdjustment = this.iBoundaryPosition;
                this.iBoundaryPosition = 0;
            } else {
                this.iBoundaryAdjustment = crnl_length;
                this.iBoundaryPosition -= crnl_length;
            }
            log.debug("searchBoundary() - found boundary at ", this.iBoundaryPosition);
            this.iTakeLimit = this.iBoundaryPosition;
        } else {
            this.iTakeLimit = this.iEnd - (this.boundary.length - 1);
            log.debug("searchBoundary() - no match, preserved boundary.length-1 bytes");
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int byteRead = this.readFromBuffer();
            if (byteRead != -2) {
                return byteRead;
            }
            this.logSnapShot("input buffer exhausted, so filling.");
            this.fillBuffer(this.boundary.length + 2);
            this.searchBoundary();
            byteRead = this.readFromBuffer();
            if (byteRead != -2) {
                return byteRead;
            }
            log.warn("Malformed boundary");
            throw new IOException();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            log.warn("MimeParseInputStream.read() threw an exception", ex);
            throw new IOException();
        }
    }

    private int readFromBuffer() {
        if (this.bAtPartEnd || this.bExhausted) {
            return -1;
        }
        this.hasNextCalled = false;
        if (this.iTake < this.iTakeLimit) {
            ++this.totalByteReadCount;
            return this.buffer[this.iTake++] & 0xFF;
        }
        if (this.iTake == this.iBoundaryPosition) {
            log.debug("read reached boundary");
            this.bAtPartEnd = true;
            return -1;
        }
        return -2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            if (this.bAtPartEnd || this.bExhausted) {
                return -1;
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            int i = 1;
            if (this.iTake < this.iTakeLimit && len > 1) {
                int iRead = this.iTakeLimit - this.iTake;
                iRead = Math.min(len - 1, iRead);
                this.totalByteReadCount += iRead;
                System.arraycopy(this.buffer, this.iTake, b, off + 1, iRead);
                this.iTake += iRead;
                i += iRead;
                if (this.iTake == this.iBoundaryPosition) {
                    log.debug("read reached boundary");
                    this.bAtPartEnd = true;
                }
            }
            return i;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            log.warn("MimeParseInputStream.read() threw an exception", ex);
            throw new IOException();
        }
    }

    @Override
    public void close() throws IOException {
        log.debug("close() called");
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.upstream.markSupported()) {
            throw new IOException("Mark/reset not supported");
        }
        this.initializeFields();
        this.upstream.reset();
        this.upstream.mark(0);
        this.advance();
    }

    boolean hasNext() throws IOException {
        if (this.hasNextCalled) {
            return this.hasMore;
        }
        this.hasMore = this.advance();
        this.hasNextCalled = true;
        return this.hasMore;
    }

    public boolean advance() throws IOException {
        try {
            if (this.bExhausted) {
                return false;
            }
            if (this.hasNextCalled) {
                return true;
            }
            this.logSnapShot("advancing");
            while (-1 != this.read()) {
            }
            this.hasNextCalled = false;
            this.iTake += this.boundary.length + this.iBoundaryAdjustment;
            this.totalByteReadCount += this.boundary.length + this.iBoundaryAdjustment;
            if (this.iEnd - this.iTake < 2) {
                this.fillBuffer(2);
            }
            if (this.iEnd - this.iTake < 2) {
                throw new IOException("MALFORMED_MIME_MULTIPART");
            }
            if (this.buffer[this.iTake] == 45 && this.buffer[this.iTake + 1] == 45) {
                log.debug("matched end boundary");
                this.bExhausted = true;
                return false;
            }
            byte nextChar = this.buffer[this.iTake];
            if (!(nextChar != 13 && nextChar != 10 || (nextChar = this.buffer[++this.iTake]) != 13 && nextChar != 10)) {
                ++this.iTake;
            }
            if (this.iEnd - this.iTake < this.boundary.length) {
                this.fillBuffer(this.boundary.length + 2);
            }
            this.searchBoundary();
            this.bAtPartEnd = this.iTake == this.iTakeLimit;
            this.logSnapShot("finished advance()");
            return true;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            log.warn("MimeParseInputStream.advance() threw an exception", ex);
            throw new IOException();
        }
    }

    private int readFromUpstream(byte[] buffer, int startPosition, int bytesToFill) throws IOException {
        if (MimeParseInputStream.isFastStreamReadEnabled()) {
            return this.fastReadFromUpstream(buffer, startPosition, bytesToFill);
        }
        return this.slowReadFromUpstream(buffer, startPosition, bytesToFill);
    }

    private int fastReadFromUpstream(byte[] buffer, int startPosition, int bytesToFill) throws IOException {
        try {
            log.debug(this.hashCode(), " Fast reading upstream ");
            log.debug(this.hashCode(), " startPosition:" + String.valueOf(startPosition) + "  bytesToFill:" + String.valueOf(bytesToFill));
            int bytesRead = this.upstream.read(buffer, startPosition, bytesToFill);
            this.logBytesReadFromUpstream(buffer, startPosition, bytesRead);
            return bytesRead;
        }
        catch (Exception e) {
            log.debug("Exception while reading upstream", e);
            return -1;
        }
    }

    private void logBytesReadFromUpstream(byte[] buffer, int startPosition, int bytesRead) {
        if (log.isDebugEnabled()) {
            log.debug("number of bytes Read From Upstream: " + bytesRead);
        }
    }

    private static boolean isFastStreamReadEnabled() {
        if (isFastStreamReadEnabled == null) {
            isFastStreamReadEnabled = MimeParseInputStream.getFastStreamReadProperty();
        }
        return isFastStreamReadEnabled;
    }

    private static Boolean getFastStreamReadProperty() {
        boolean propertyValue = Boolean.valueOf(PropertyInserter.getProperty(FAST_STREAM_READ_PROPERTY, FAST_STREAM_READ_DEFAULT));
        log.info(FAST_STREAM_READ_PROPERTY, "=", propertyValue);
        return propertyValue;
    }

    private int slowReadFromUpstream(byte[] buffer, int startPosition, int bytesToFill) throws IOException {
        int bytesRead = 0;
        int aByte = this.upstream.read();
        if (aByte == -1) {
            return -1;
        }
        buffer[startPosition++] = (byte)(aByte & 0xFF);
        --bytesToFill;
        ++bytesRead;
        while (bytesToFill > 0 && (aByte = this.upstream.read()) != -1) {
            buffer[startPosition++] = (byte)(aByte & 0xFF);
            --bytesToFill;
            ++bytesRead;
        }
        return bytesRead;
    }

    void closeUpstream() {
        try {
            log.debug("Closing the upstream");
            this.upstream.close();
        }
        catch (IOException ex) {
            log.debug("Upstream threw exception in closeUpstream()", ex);
        }
    }

    @Override
    public boolean markSupported() {
        return this.upstream.markSupported();
    }

    static {
        crnl_length = 2;
        String property = PropertyInserter.getProperty("MIMEParseBoundaryFix");
        if (property != null && property.equalsIgnoreCase("false")) {
            crnl_length = 0;
        }
    }
}

