/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MCUtils;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.MessageContextValue;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class MessageContextImpl
implements MessageContext {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private long arrival_time;
    private ArrayList<Handler> trace_back_stack = new ArrayList();
    private Fault aFault;
    private String cn_response;
    private boolean has_responded;
    private ArrayList<Cookie> cookies_to_set;
    private ArrayList<Handler> preRespondHooks;
    private static String[] responseProperties = new String[]{".status_code", ".envelope", ".headers", ".boundary", ".attachments"};

    public MessageContextImpl() {
        MCUtils.setPerformanceIndicator(this);
    }

    @Override
    public void setProperty(String name, Object o) {
        this.properties.put(name, o);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getStrProperty(String name) {
        return (String)this.properties.get(name);
    }

    @Override
    public int getIntProperty(String name, int defval) {
        String s = this.getStrProperty(name);
        if (s == null) {
            return defval;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defval;
        }
    }

    @Override
    public long getArrivalTime() {
        return this.arrival_time;
    }

    @Override
    public void setArrivalTime(long t) {
        this.arrival_time = t;
    }

    @Override
    public boolean hasResponded() {
        return this.has_responded;
    }

    @Override
    public void respond(String cn) throws IOException {
        if (!this.has_responded) {
            PogoResponder pr = (PogoResponder)this.getProperty("pogo.responder");
            HttpServletResponse response = (HttpServletResponse)this.getProperty("servlet.response");
            this.setProperty("responseContextName", cn);
            this.setResponseName(cn);
            this.invokePreRespondHooks();
            try {
                this.has_responded = pr.respond(response, this, cn);
            }
            catch (Exception ex) {
                cat.warn("Exception caught while attempting to respond", ex);
                this.has_responded = true;
            }
        } else {
            cat.debug("attempt to respond twice");
        }
    }

    @Override
    public void addPreRespondHook(Handler h) {
        if (this.preRespondHooks == null) {
            this.preRespondHooks = new ArrayList();
        }
        this.preRespondHooks.add(h);
    }

    private void invokePreRespondHooks() {
        if (this.preRespondHooks != null) {
            for (Handler hook : this.preRespondHooks) {
                cat.debug("pre-respond hook: ", hook.getName());
                try {
                    hook.invoke(this);
                }
                catch (PogoException x) {
                    cat.error("Unexpected PogoException when invoking PreSendHook: " + hook.getName(), x);
                }
            }
        }
    }

    @Override
    public void setFault(Fault f) {
        this.aFault = f;
        if (this.aFault != null) {
            this.aFault.setMessageContext(this);
        }
    }

    @Override
    public Fault getFault() {
        return this.aFault;
    }

    @Override
    public boolean isFaulted() {
        return this.aFault != null;
    }

    @Override
    public void setResponseName(String root_name) {
        if (cat.isDebugEnabled() && this.cn_response != null && !this.cn_response.equals(root_name)) {
            cat.warn("setResponseName(): response context name was set already.  old value=", this.cn_response, ", new value=", root_name);
        }
        this.cn_response = root_name;
    }

    @Override
    public String getResponseName() {
        return this.cn_response;
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.cookies_to_set == null) {
            this.cookies_to_set = new ArrayList();
        }
        this.cookies_to_set.add(cookie);
    }

    @Override
    public Iterator<Cookie> getCookiesToSet() {
        if (this.cookies_to_set == null) {
            return Collections.emptyList().iterator();
        }
        return this.cookies_to_set.iterator();
    }

    @Override
    public List<Cookie> getCookieListToSet() {
        if (this.cookies_to_set == null) {
            return Collections.emptyList();
        }
        return this.cookies_to_set;
    }

    public void clearCookies() {
        this.cookies_to_set = null;
    }

    @Override
    public void pushTB(Handler h) {
        this.trace_back_stack.add(h);
    }

    @Override
    public Handler popTB() {
        return this.trace_back_stack.remove(this.trace_back_stack.size() - 1);
    }

    @Override
    public List<Handler> getHandlerTraceBackSnapShot() {
        return new ArrayList<Handler>(this.trace_back_stack);
    }

    public MessageContextImpl createRequestContextCopy() {
        MessageContextImpl mcCopy = new MessageContextImpl();
        mcCopy.setArrivalTime(this.getArrivalTime());
        Iterator<Map.Entry<String, Object>> itProp = this.getPropertiesIterator();
        while (itProp.hasNext()) {
            Map.Entry<String, Object> me = itProp.next();
            Object value = me.getValue();
            String key = me.getKey();
            if (value == null) {
                mcCopy.setProperty(key, null);
                continue;
            }
            if (value instanceof String) {
                mcCopy.setProperty(key, value);
                continue;
            }
            if (value instanceof Boolean) {
                mcCopy.setProperty(key, value);
                continue;
            }
            if (value instanceof Locale) {
                mcCopy.setProperty(key, value);
                continue;
            }
            if (value instanceof InternetHeaders) {
                InternetHeaders srcHdrs = (InternetHeaders)me.getValue();
                InternetHeaders destHdrs = new InternetHeaders();
                Enumeration enumHdrs = srcHdrs.getAllHeaders();
                while (enumHdrs.hasMoreElements()) {
                    Header h = (Header)enumHdrs.nextElement();
                    destHdrs.addHeader(h.getName(), h.getValue());
                }
                mcCopy.setProperty(key, destHdrs);
                continue;
            }
            if (value instanceof BIBusEnvelope) {
                BIBusEnvelope srcEnv = (BIBusEnvelope)value;
                try {
                    mcCopy.setProperty(key, srcEnv.clone());
                }
                catch (CloneNotSupportedException e) {
                    cat.error("failed to create copy: ", e);
                }
                continue;
            }
            if (value instanceof PogoResponder) continue;
            if (value instanceof ArrayList && "cleanup".equals(key)) {
                mcCopy.setProperty(key, new ArrayList());
                continue;
            }
            if (value instanceof MIMEPartParser) {
                cat.debug("createCopy(): moving MIMEPartParser from original mc to copy: ", key);
                mcCopy.setProperty(key, value);
                itProp.remove();
                continue;
            }
            if (value instanceof MessageContextValue) {
                mcCopy.setProperty(key, value);
                continue;
            }
            cat.debug("createCopy(): skipping unknown property: ", key, ", ", value.getClass().getName());
        }
        return mcCopy;
    }

    protected Iterator<Map.Entry<String, Object>> getPropertiesIterator() {
        return this.properties.entrySet().iterator();
    }

    public void collectResponse(MessageContextImpl mcSrc) {
        String respName = mcSrc.getResponseName();
        this.setResponseName(respName);
        for (int i = 0; i < responseProperties.length; ++i) {
            String propName = respName + responseProperties[i];
            this.setProperty(propName, mcSrc.getProperty(propName));
        }
        List<Cleanable> srcCleanables = mcSrc.getCleanables();
        if (srcCleanables != null && srcCleanables.size() > 0) {
            List<Cleanable> destCleanables = this.getCleanables();
            if (destCleanables == null) {
                destCleanables = new ArrayList<Cleanable>();
                this.setProperty("cleanup", destCleanables);
            }
            destCleanables.addAll(srcCleanables);
            srcCleanables.clear();
        }
        Iterator<Cookie> itCookies = mcSrc.getCookiesToSet();
        while (itCookies.hasNext()) {
            this.addCookie(itCookies.next());
        }
        this.setFault(mcSrc.getFault());
        if (mcSrc.preRespondHooks != null && mcSrc.preRespondHooks.size() > 0) {
            if (this.preRespondHooks == null) {
                this.preRespondHooks = new ArrayList();
            }
            this.preRespondHooks.addAll(mcSrc.preRespondHooks);
            mcSrc.preRespondHooks.clear();
        }
    }

    private List<Cleanable> getCleanables() {
        return MCUtils.getCleanables(this);
    }
}

