/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.pogo.handlers.util.AdvancedSettingParameterHandler;
import com.cognos.pogo.http.inprocess.LocalServerConnection;
import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.impl.CookieEncodeInfo;
import com.cognos.pogo.impl.SetCookieEncoderFactory;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public abstract class PogoResponder {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final CookieEncodeInfo COOKIE_ENCODE_INFO = new CookieEncodeInfo();
    static final String SET_COOKIE = "Set-Cookie";
    static final String X_FRAME_OPTIONS_PROPERTY = "PogoResponder.XFrameOptions.enabled";
    private static final String X_FRAME_OPTIONS_DEFAULT = "false";

    public final boolean respond(HttpServletResponse response, MessageContext mc, String cn) throws IOException {
        if (PogoResponder.getXFrameOptionProperty().booleanValue()) {
            response.addHeader("X-FRAME-OPTIONS", "SAMEORIGIN");
        }
        this.setCookies(response, mc);
        PerformanceIndicator.getListener().handlePogoResponseSent(response);
        return this.respondImpl(response, mc, cn);
    }

    protected void setCookies(HttpServletResponse response, MessageContext mc) {
        log.debug(this, ": Checking MessageContext for cookies to set in the response as HTTP headers");
        CookieEncodeInfo cookieEncodeInfo = this.getCookieEncodeInfo();
        Iterator<Cookie> it = mc.getCookiesToSet();
        if (cookieEncodeInfo.areAllCookiesCustomEncoded()) {
            while (it.hasNext()) {
                Cookie aCookie = it.next();
                log.debug("Setting cookie ", aCookie.getName(), "=", aCookie.getValue(), " as HTTP cookie header using addHeader");
                response.addHeader(SET_COOKIE, SetCookieEncoderFactory.newSetCookieEncoder(aCookie).generateSetCookie());
            }
        } else {
            while (it.hasNext()) {
                Cookie aCookie = it.next();
                if (this.shouldUseSetCookieHeader(cookieEncodeInfo, aCookie.getName())) {
                    log.debug("Setting cookie ", aCookie.getName(), "=", aCookie.getValue(), " as HTTP cookie header using addHeader");
                    response.addHeader(SET_COOKIE, SetCookieEncoderFactory.newSetCookieEncoder(aCookie).generateSetCookie());
                    continue;
                }
                log.debug("Setting cookie ", aCookie.getName(), "=", aCookie.getValue(), " as HTTP cookie header using addCookie");
                response.addCookie(aCookie);
            }
        }
    }

    private boolean shouldUseSetCookieHeader(CookieEncodeInfo cookieEncodeInfo, String cookieName) {
        return cookieEncodeInfo.isCookieListedAsCustomEncoded(cookieName) || cookieName.equalsIgnoreCase("cam_passport");
    }

    CookieEncodeInfo getCookieEncodeInfo() {
        return COOKIE_ENCODE_INFO;
    }

    void closeAllAttachmentStreams(InputStream currentStream, Iterator<InputStream> attachments) {
        try {
            if (currentStream != null) {
                currentStream.close();
            }
        }
        catch (IOException ex) {
            log.debug("Exception caught while closing attachment streams", ex);
        }
        if (attachments instanceof MIMEPartParser) {
            ((MIMEPartParser)attachments).close();
            return;
        }
        try {
            while (attachments.hasNext()) {
                InputStream inStream = attachments.next();
                inStream.close();
            }
        }
        catch (IOException ex) {
            log.debug("Exception caught while closing attachment streams", ex);
        }
    }

    protected abstract boolean respondImpl(HttpServletResponse var1, MessageContext var2, String var3) throws IOException;

    protected String quoteETagValue(String eTagValue) {
        boolean endsWithQuote;
        if (eTagValue == null || eTagValue.length() == 0) {
            return eTagValue;
        }
        boolean startsWithQuote = eTagValue.charAt(0) == '\"';
        boolean bl = endsWithQuote = eTagValue.charAt(eTagValue.length() - 1) == '\"';
        if (startsWithQuote && endsWithQuote) {
            return eTagValue;
        }
        StringBuffer strBuf = new StringBuffer();
        if (!startsWithQuote) {
            strBuf.append("\"");
        }
        strBuf.append(eTagValue);
        if (!endsWithQuote) {
            strBuf.append("\"");
        }
        return strBuf.toString();
    }

    protected Iterator<InputStream> getAttachments(MessageContext mc, String cn) {
        Iterator attachments = (Iterator)mc.getProperty(cn + ".attachments");
        if (!LocalServerConnection.hasLocalServerConnection(mc)) {
            mc.setProperty(cn + ".attachments", null);
        }
        return attachments;
    }

    private static Boolean getXFrameOptionProperty() {
        boolean propertyValue = Boolean.valueOf(AdvancedSettingParameterHandler.getValue(X_FRAME_OPTIONS_PROPERTY, X_FRAME_OPTIONS_DEFAULT));
        return propertyValue;
    }

    static {
        COOKIE_ENCODE_INFO.parseCookieList();
    }
}

