/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.impl;

import com.cognos.p2pd.httptools.MimeHeaderUtil;
import com.cognos.pogo.handlers.contentmanager.viewer.SoapEncodingHeaderProcessor;
import com.cognos.pogo.http.mime.MimeParseInputStream;
import com.cognos.pogo.impl.PogoResponder;
import com.cognos.pogo.impl.PogoSOAPMessageResponder;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.LengthLimitedInputStream;
import com.cognos.pogo.util.PogoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class PogoSOAPAttachmentResponder
extends PogoResponder {
    static final PogoLogger cat = PogoLogger.getLogger();
    private static final PogoLogger perf_cat = PogoLogger.getLoggerFor("perf." + cat.getName());

    @Override
    public boolean respondImpl(HttpServletResponse response, MessageContext mc, String cn) throws IOException {
        BIBusEnvelope request_env;
        String forceString;
        int value;
        int status_code = mc.getIntProperty(cn + ".status_code", 500);
        if (mc.isFaulted() && (value = mc.getFault().getHTTPStatusOverride()) != -1) {
            status_code = value;
        }
        BIBusEnvelope response_env = (BIBusEnvelope)mc.getProperty(cn + ".envelope");
        if (status_code != 304 && response_env == null) {
            cat.error("No response was generated.");
            if (null == mc.getFault()) {
                mc.setFault(new Fault("NO_RESPONSE"));
            }
            return false;
        }
        boolean forceSOAPFault = false;
        if (mc.getFault() != null && "true".equalsIgnoreCase(forceString = (request_env = (BIBusEnvelope)mc.getProperty("request.envelope")).getFormValue("forceSOAPFault"))) {
            forceSOAPFault = true;
        }
        if (status_code == 304 || status_code == 599 || mc.getFault() != null && forceSOAPFault) {
            PogoSOAPMessageResponder alternateResponder = new PogoSOAPMessageResponder();
            return ((PogoResponder)alternateResponder).respondImpl(response, mc, cn);
        }
        response.setStatus(status_code);
        return this.processAttachments(response, mc, cn, response_env);
    }

    protected boolean processAttachments(HttpServletResponse response, MessageContext mc, String cn, BIBusEnvelope response_env) throws IOException {
        Iterator<InputStream> attachments = this.getAttachments(mc, cn);
        if (attachments == null || !attachments.hasNext()) {
            this.handleMissingAttachment(response);
        } else {
            int byteranges = mc.getIntProperty("byteRanges", 0);
            byte[] buf = this.createResponseBuffer();
            while (attachments.hasNext()) {
                String[] eTagValues;
                InternetHeaders response_hdrs;
                InputStream pis = attachments.next();
                InternetHeaders part_headers = null;
                try {
                    part_headers = new InternetHeaders(pis);
                }
                catch (Exception x) {
                    throw new IOException(x.getMessage());
                }
                int partContentLength = -1;
                boolean sendETag = true;
                Enumeration enumHdrs = part_headers.getAllHeaders();
                while (enumHdrs.hasMoreElements()) {
                    Header hdr = (Header)enumHdrs.nextElement();
                    String name = hdr.getName();
                    String value = hdr.getValue();
                    if (name.equalsIgnoreCase("transfer-encoding") && value.equals("chunked") || name.equalsIgnoreCase("content-encoding") && value.equals("gzip")) continue;
                    if (name.equalsIgnoreCase("Content-Length")) {
                        try {
                            partContentLength = Integer.parseInt(value);
                        }
                        catch (NumberFormatException nfx) {
                            partContentLength = -1;
                        }
                        if (byteranges > 0) {
                            continue;
                        }
                    } else {
                        if (name.equalsIgnoreCase("Content-Type")) {
                            if (value.indexOf("text/html") != -1 && value.indexOf("charset=") == -1) {
                                cat.warn("text/html response content type is missing charset, will force to utf-8");
                                StringBuffer sb = new StringBuffer(value.trim());
                                if (sb.length() == 0) {
                                    cat.error("response content type is empty, raising a fault");
                                    if (null == mc.getFault()) {
                                        mc.setFault(new Fault("Response does not have Content-Type header."));
                                    }
                                    return false;
                                }
                                if (sb.charAt(sb.length() - 1) != ';') {
                                    sb.append("; charset=utf-8");
                                } else {
                                    sb.append(" charset=utf-8");
                                }
                                response.setContentType(sb.toString());
                                continue;
                            }
                            sendETag = this.processContentType(response, response_env, value, mc);
                            continue;
                        }
                        if (name.equalsIgnoreCase("Set-Cookie")) continue;
                    }
                    PogoSOAPAttachmentResponder.setHeader(response, name, value);
                }
                if (sendETag && (response_hdrs = (InternetHeaders)mc.getProperty(cn + ".headers")) != null && (eTagValues = response_hdrs.getHeader("ETag")) != null && eTagValues.length > 0 && eTagValues[0] != null) {
                    cat.debug("Using Etag value: ", eTagValues[0]);
                    PogoSOAPAttachmentResponder.setHeader(response, "ETag", this.quoteETagValue(eTagValues[0]));
                }
                pis = this.processGzipAndLength(response, mc, pis, part_headers, partContentLength);
                ServletOutputStream outStream = response.getOutputStream();
                perf_cat.info("Started writing attachment part....");
                cat.debug("Writing attachment part...");
                try {
                    this.writeInputToOutput(buf, pis, (OutputStream)outStream);
                }
                catch (IOException ioe) {
                    this.closeAllAttachmentStreams(pis, attachments);
                    throw ioe;
                }
                catch (Exception ex) {
                    this.closeAllAttachmentStreams(pis, attachments);
                    cat.warn("Caught unexpected exception", ex);
                    throw new IOException();
                }
                perf_cat.info("Finished writing attachment part.");
                cat.debug("Finished writing attachment part.");
            }
        }
        return true;
    }

    void handleMissingAttachment(HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    protected InputStream processGzipAndLength(HttpServletResponse response, MessageContext mc, InputStream part, InternetHeaders partHeaders, int partContentLength) throws IOException {
        if (MimeHeaderUtil.isGzip(partHeaders)) {
            if (mc.getProperty("clientUnderstandsGZip") == null) {
                part = new GZIPInputStream(part);
            } else {
                PogoSOAPAttachmentResponder.setHeader(response, "Content-Encoding", "gzip");
            }
        } else if (partContentLength > 0) {
            cat.debug("Using attachment's content length: ", partContentLength);
            part = new LengthLimitedInputStream(part, partContentLength);
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInputToOutput(byte[] buf, InputStream pis, OutputStream outStream) throws IOException {
        try {
            int iread;
            while ((iread = pis.read(buf)) > 0) {
                outStream.write(buf, 0, iread);
            }
            outStream.flush();
        }
        finally {
            pis.close();
        }
    }

    byte[] createResponseBuffer() {
        return MimeParseInputStream.createResponseBuffer();
    }

    boolean processContentType(HttpServletResponse response, BIBusEnvelope response_env, String contentType, MessageContext mc) {
        response.setContentType(contentType);
        boolean sendETag = false;
        if (response_env != null) {
            SoapEncodingHeaderProcessor processor = new SoapEncodingHeaderProcessor(response_env);
            String userAgent = MimeHeaderUtil.getUserAgent(mc);
            processor.createHeaders(contentType, userAgent);
            processor.setHeader(response);
            sendETag = this.sendETag(processor);
        }
        return sendETag;
    }

    private boolean sendETag(SoapEncodingHeaderProcessor processor) {
        return !processor.isExcelType();
    }

    private static final void setHeader(HttpServletResponse response, String name, String value) {
        if (response.isCommitted()) {
            cat.debug("Cannot set header for name=", name, ". Response already committed");
        } else {
            response.setHeader(name, value);
        }
    }
}

