/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.CounterBase;

public class DurationCounter
extends CounterBase {
    private long count = 0L;
    private long total = 0L;

    public DurationCounter(String name) {
        super(name);
    }

    @Override
    public void getXML(StringBuffer sb) {
        sb.append('<').append(this.getName());
        sb.append(" count=\"").append(this.count);
        sb.append("\" averageDuration=\"");
        if (this.count == 0L || this.total == 0L) {
            sb.append("0");
        } else {
            sb.append(this.total / this.count);
        }
        sb.append("\"/>");
    }

    @Override
    public void reset() {
        this.count = 0L;
        this.total = 0L;
    }

    public void update(long observedDuration) {
        ++this.count;
        this.total += observedDuration;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }
}

