/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring;

import com.cognos.pogo.monitoring.QueueableRequestReporter;
import com.cognos.pogo.monitoring.RequestInfo;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class QueueableRequestReportingHandler
extends SimpleRequestReportingHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(QueueableRequestReportingHandler.class.getName());
    private String cnRequestInfo;
    private boolean disabled;

    public QueueableRequestReportingHandler() {
        super(cat);
    }

    public String getCnRequestInfo() {
        return this.cnRequestInfo;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        this.disabled = true;
        this.cnRequestInfo = this.getRequiredAttribute(cat, "cnRequestInfo");
    }

    @Override
    protected RequestReporter instantiateReporter(String reporterName, String serviceType) {
        return new QueueableRequestReporter(reporterName, serviceType);
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.disabled = false;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.disabled) {
            cat.debug("reporting of runtime info is disabled.");
            return;
        }
        QueueableRequestReporter queueableReporter = this.getQueueableRequestReporter();
        RequestInfo ri = (RequestInfo)mc.getProperty(this.cnRequestInfo);
        if (ri != null) {
            ri.setProcessTime(System.currentTimeMillis() - mc.getArrivalTime());
        }
        if (mc.isFaulted()) {
            if (ri != null) {
                queueableReporter.reportFailure(ri);
            } else {
                queueableReporter.reportFailure(System.currentTimeMillis() - mc.getArrivalTime());
            }
        } else if (ri != null) {
            queueableReporter.reportSuccess(ri);
        } else {
            queueableReporter.reportSuccess(System.currentTimeMillis() - mc.getArrivalTime());
        }
    }

    public QueueableRequestReporter getQueueableRequestReporter() {
        return (QueueableRequestReporter)this.getRequestReporter();
    }
}

