/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.example;

import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class HowToGetaReporter
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(HowToGetaReporter.class.getName());
    private PogoEngine engine;
    private String reporterName;
    private RequestReporter reporter;

    public HowToGetaReporter() {
        super(cat);
    }

    public RequestReporter getReporter() {
        return this.reporter;
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        this.reporterName = this.getRequiredAttribute(cat, "reporterName");
    }

    @Override
    public void initialize() {
        try {
            Handler h = this.engine.getHandlerPool().find(this.reporterName);
            if (h != null && h instanceof SimpleRequestReportingHandler) {
                SimpleRequestReportingHandler srrh = (SimpleRequestReportingHandler)h;
                this.reporter = srrh.getRequestReporter();
                if (this.reporter == null) {
                    cat.error("reporter is null, perhaps " + h.getName() + " hasn't been composed yet?");
                } else {
                    cat.debug("found reporter on handler " + h.getName());
                }
            } else {
                cat.error("can't find SimpleRequestReportingHandler named: \"" + this.reporterName + "\"");
            }
        }
        catch (Exception x) {
            cat.error("", (Throwable)x);
        }
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (mc.isFaulted()) {
            this.reporter.reportFailure(0L);
        } else {
            long processTime = 100L;
            this.reporter.reportSuccess(processTime);
        }
    }
}

