/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnection;
import com.cognos.pogo.monitoring.jmx.JMXDispatcherConnectionFactory;
import com.cognos.pogo.util.PogoLogger;
import javax.management.MBeanServerConnection;
import javax.management.NotificationListener;

public class JMXDispatcher {
    private static final PogoLogger log = PogoLogger.getLogger();
    private String name;
    private String jmxUrl;
    private boolean available;
    private JMXDispatcherConnection jmxDispatcherConnection;

    public JMXDispatcher(DispatcherListElement element) {
        this(element.toString(), element.getJmxUrl(), element.isAvailable());
    }

    public JMXDispatcher(String jmxUrl) {
        this(jmxUrl, jmxUrl, true);
    }

    public JMXDispatcher(String name, String jmxUrl, boolean available) {
        this.name = name;
        this.jmxUrl = jmxUrl.toLowerCase();
        this.available = available;
        this.jmxDispatcherConnection = JMXDispatcherConnectionFactory.createConnection(name, this.jmxUrl);
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public MBeanServerConnection getMbeanServerConnection() {
        return this.jmxDispatcherConnection.getMbeanServerConnection();
    }

    public String getName() {
        return this.name;
    }

    public boolean canConnect() {
        try {
            return this.jmxDispatcherConnection.canConnect();
        }
        catch (Exception e) {
            log.info("Exception checking connection to " + this.name, e);
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof JMXDispatcher) {
            JMXDispatcher other = (JMXDispatcher)obj;
            return this.name.equals(other.name) && this.available == other.available;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        log.debug("Setting availability of dispatcher: ", this.name, " from ", this.available, " to ", available);
        this.available = available;
    }

    public boolean isLocalActiveCM() {
        NodeID cmNode;
        if (this.isLocalDispatcher() && (cmNode = NodeIdGuidMapper.getContentManagerNID()).isLocalToSelf()) {
            String context = PropertyInserter.getProperty("dispatcher.context");
            return cmNode.getPath().startsWith(context);
        }
        return false;
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.jmxDispatcherConnection.setNotificationListener(notificationListener);
    }

    public void disconnect() {
        this.jmxDispatcherConnection.disconnect();
    }

    public boolean isConnected() {
        return this.jmxDispatcherConnection.isConnected();
    }

    public boolean isLocalDispatcher() {
        return this.jmxDispatcherConnection != null && this.jmxDispatcherConnection.isLocalDispatcher();
    }
}

