/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.config.DispatcherList;
import com.cognos.pogo.config.DispatcherListElement;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class JMXDispatcherList {
    private HashMap<String, JMXDispatcher> completeList = new HashMap();
    private HashMap<String, JMXDispatcher> removed;
    private HashMap<String, JMXDispatcher> added;

    public JMXDispatcherList() {
        this(new HashMap<String, JMXDispatcher>());
    }

    public JMXDispatcherList(DispatcherList dispatcherList) {
        this.createList(dispatcherList);
    }

    public JMXDispatcherList(HashMap<String, JMXDispatcher> dl) {
        this.completeList = new HashMap<String, JMXDispatcher>(dl);
    }

    public void add(JMXDispatcher jmxDispatcher) {
        this.add(this.completeList, jmxDispatcher);
    }

    private void createList(DispatcherList dispatcherList) {
        HashMap<String, JMXDispatcher> hashMap = new HashMap<String, JMXDispatcher>();
        for (DispatcherListElement element : dispatcherList.getCompleteDispatcherListElements()) {
            JMXDispatcher jmxDispatcher = new JMXDispatcher(element);
            this.add(hashMap, jmxDispatcher);
        }
        this.completeList = hashMap;
    }

    private void add(HashMap<String, JMXDispatcher> hashMap, JMXDispatcher jmxDispatcher) {
        hashMap.put(jmxDispatcher.getName(), jmxDispatcher);
    }

    public Iterator<JMXDispatcher> iterator() {
        return this.completeIterator();
    }

    public Iterator<JMXDispatcher> completeIterator() {
        return this.completeList.values().iterator();
    }

    public boolean equals(Object other) {
        if (!(other instanceof JMXDispatcherList)) {
            return false;
        }
        JMXDispatcherList otherJMXDispatcherList = (JMXDispatcherList)other;
        return this.completeList.equals(otherJMXDispatcherList.completeList);
    }

    public int hashCode() {
        return this.completeList.hashCode();
    }

    public int size() {
        return this.completeList.size();
    }

    public JMXDispatcher getDispatcher(String dispatcherName) {
        return this.completeList.get(dispatcherName);
    }

    public void update(JMXDispatcherList newJMXDispatcherList) {
        HashMap<String, JMXDispatcher> list2 = newJMXDispatcherList.completeList;
        this.removed = this.difference(this.completeList, list2);
        this.added = this.difference(list2, this.completeList);
        this.completeList = list2;
    }

    private HashMap<String, JMXDispatcher> difference(HashMap<String, JMXDispatcher> list1, HashMap<String, JMXDispatcher> list2) {
        HashMap<String, JMXDispatcher> master = new HashMap<String, JMXDispatcher>(list1);
        master.keySet().removeAll(list2.keySet());
        return master;
    }

    public JMXDispatcherList getRemoved() {
        return new JMXDispatcherList(this.removed);
    }

    public JMXDispatcherList getAdded() {
        return new JMXDispatcherList(this.added);
    }

    public Collection<JMXDispatcher> values() {
        return this.completeList.values();
    }
}

