/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.p2pd.util.PropertyInserter;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanHessianServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanHttpServerConnector;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanJmxmpServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanLocalRMIServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanProxyHessianServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanRemoteRMIServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoMBeanServerConnection;
import com.cognos.pogo.monitoring.jmx.utils.PogoRmiRegistry;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class PogoMBeanServerJMX
extends PogoMBeanServer {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PogoMBeanServerJMX.class.getName());
    protected MBeanServer proxyserver;
    private PogoRmiRegistry pogoRmiRegistry = new PogoRmiRegistry();
    private PogoMBeanRemoteRMIServerConnection remoteRMIProxyServerConnection = null;
    private PogoMBeanHessianServerConnection proxyHessianServerConnection = null;
    private PogoMBeanJmxmpServerConnection proxyJmxmpServerConnection = null;
    private PogoMBeanHttpServerConnector proxyHTTPServerConnection = null;

    protected PogoMBeanServerJMX() {
    }

    @Override
    protected void createMBeanServer() {
        try {
            System.setProperty("mx4j.remote.resolver.pkgs", "com.cognos.pogo.monitoring.jmx.remote.resolver");
            this.server = ManagementFactory.getPlatformMBeanServer();
            this.startLocalRMIConnector();
        }
        catch (Exception e) {
            cat.error("Unable to start MBean server", (Throwable)e);
        }
    }

    @Override
    public MBeanServer createProxyMBeanServer() throws Exception {
        this.createProxyServer();
        this.startProxyRMIConnector();
        this.startProxyJMXMPConnector();
        this.startHTTPConnector();
        this.startProxyHessianConnector();
        return this.proxyserver;
    }

    @Override
    public MBeanServer getProxyMBeanServer() {
        if (this.proxyserver == null) {
            this.createProxyServerForTesting();
        }
        return this.proxyserver;
    }

    @Override
    public void stopServer() {
        this.pogoRmiRegistry.stopRMIRegistry();
    }

    @Override
    public Long getServerConnectionTimeout() {
        String property = PropertyInserter.getProperty("MbeanServerConnectionTimeout");
        try {
            return Long.parseLong(property);
        }
        catch (NumberFormatException e) {
            return DEFAULT_SERVER_CONNECTION_TIMEOUT;
        }
    }

    @Override
    public void startHessianConnector() {
        try {
            PogoMBeanHessianServerConnection connection = new PogoMBeanHessianServerConnection(this.server);
            connection.start();
        }
        catch (Exception e) {
            cat.error("Unable to create Hessian JMX connection ", (Throwable)e);
        }
    }

    private void createProxyServer() {
        this.proxyserver = MBeanServerFactory.createMBeanServer(PogoMBeanServerJMX.getJmxDomain());
        cat.debug("created proxy server: " + this.proxyserver);
    }

    private void createProxyServerForTesting() {
        try {
            this.createProxyServer();
        }
        catch (Exception e) {
            cat.debug("exception creating proxy server", (Throwable)e);
        }
    }

    private void startLocalRMIConnector() {
        try {
            PogoMBeanLocalRMIServerConnection connection = new PogoMBeanLocalRMIServerConnection(this.server, this.pogoRmiRegistry);
            ((PogoMBeanServerConnection)connection).start();
        }
        catch (Exception e) {
            cat.info("Exception creating RMI connector to local mbean server: ", (Throwable)e);
        }
    }

    @Override
    public void startProxyRMIConnector() {
        try {
            cat.debug("startProxyRMIConnector() - start proxy RMI connector...");
            PogoMBeanRemoteRMIServerConnection connection = new PogoMBeanRemoteRMIServerConnection(this.proxyserver, this.pogoRmiRegistry);
            connection.start();
            this.remoteRMIProxyServerConnection = connection;
        }
        catch (Exception e) {
            cat.info("Exception creating RMI connector to proxy mbean server: ", (Throwable)e);
        }
    }

    @Override
    public void stopProxyRMIConnector() {
        try {
            if (this.remoteRMIProxyServerConnection != null) {
                cat.debug("stopProxyRMIConnector() - stop remote proxy RMI connector: service:jmx:rmi:///jndi/rmi://host:xxx/proxyserver.");
                this.remoteRMIProxyServerConnection.stop();
                this.remoteRMIProxyServerConnection = null;
            }
        }
        catch (Exception e) {
            cat.info("Exception stopping RMI connector to proxy mbean server: ", (Throwable)e);
        }
    }

    @Override
    public void startProxyJMXMPConnector() {
        try {
            PogoMBeanJmxmpServerConnection connection = new PogoMBeanJmxmpServerConnection(this.proxyserver);
            connection.start();
            this.proxyJmxmpServerConnection = connection;
        }
        catch (Exception e) {
            cat.info("Exception creating Jmxmp connector to proxy mbean server: ", (Throwable)e);
        }
    }

    @Override
    public void stopProxyJMXMPConnector() {
        try {
            if (this.proxyJmxmpServerConnection != null) {
                cat.debug("stopProxyJMXMPConnector() - stop Jmxmp proxy connector: service:jmx:jmxmp://localhost:port.");
                this.proxyJmxmpServerConnection.stop();
                this.proxyJmxmpServerConnection = null;
            }
        }
        catch (Exception e) {
            cat.info("Exception stopping Jmxmp proxy connector to proxy mbean server: ", (Throwable)e);
        }
    }

    private void startProxyHessianConnector() {
        try {
            PogoMBeanProxyHessianServerConnection connection = new PogoMBeanProxyHessianServerConnection(this.proxyserver);
            connection.start();
            this.proxyHessianServerConnection = connection;
        }
        catch (Exception e) {
            cat.error("Unable to create Hessian JMX connection ", (Throwable)e);
        }
    }

    private void stopProxyHessianConnector() {
        try {
            if (this.proxyHessianServerConnection != null) {
                cat.debug("stopProxyHessianConnector() - stop proxy Hessian connector: service:jmx:hessian://host:xxxx/p2pd/hessianproxy.");
                this.proxyHessianServerConnection.stop();
                this.proxyHessianServerConnection = null;
            }
        }
        catch (Exception e) {
            cat.info("Exception stopping proxy Hessian connector to proxy mbean server: ", (Throwable)e);
        }
    }

    private void startHTTPConnector() {
        PogoMBeanHttpServerConnector connector = new PogoMBeanHttpServerConnector(this.proxyserver);
        try {
            connector.start();
            this.proxyHTTPServerConnection = connector;
        }
        catch (IOException e) {
            cat.info("Unable to start HTTP Server", (Throwable)e);
        }
    }

    private void stopHTTPConnector() {
        try {
            if (this.proxyHTTPServerConnection != null) {
                cat.debug("stopProxyHessianConnector() - stop proxy HTTP connector: http://localhost:port.");
                this.proxyHTTPServerConnection.stop();
                this.proxyHTTPServerConnection = null;
            }
        }
        catch (Exception e) {
            cat.info("Exception stopping proxy HTTP connector to proxy mbean server: ", (Throwable)e);
        }
    }

    @Override
    public void setProxyMBeanServer(MBeanServer forwarder) {
        this.proxyserver = forwarder;
    }

    @Override
    public void stopProxyConnectors() {
        this.stopProxyRMIConnector();
        this.stopProxyHessianConnector();
        this.stopProxyJMXMPConnector();
        this.stopHTTPConnector();
    }
}

