/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import com.cognos.pogo.monitoring.jmx.QueueMetricsMBean;
import java.util.Date;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class QueueMetrics
extends MetricNotificationSupport
implements QueueMetricsMBean,
CounterMbeanInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor("METRICS." + QueueMetrics.class.getName());
    private String name;
    private long numberOfRequests = 0L;
    private Date NumberOfRequestsLastUpdateTime = new Date();
    private long timeInQueue = 0L;
    private Date timeInQueueLastUpdateTime = new Date();
    private long timeInQueueHighWaterMark = 0L;
    private Date timeInQueueHighWaterMarkLastUpdateTime = new Date();
    private long timeInQueueLowWaterMark = Long.MAX_VALUE;
    private Date timeInQueueLowWaterMarkLastUpdateTime = new Date();
    private long queueLength = 0L;
    private Date queueLengthLastUpdateTime = new Date();
    private long queueLengthHighWaterMark = 0L;
    private Date queueLengthHighWaterMarkLastUpdateTime = new Date();
    private long queueLengthLowWaterMark = Long.MAX_VALUE;
    private Date queueLengthLowWaterMarkLastUpdateTime = new Date();
    private Date lastResetTime = new Date();
    private final String service;

    public QueueMetrics(String name, String service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public void reset() {
        if (cat.isDebugEnabled()) {
            cat.debug("reset queue service=" + this.service);
        }
        this.sendResetNotifications();
        this.numberOfRequests = 0L;
        this.setNumberOfRequestsLastUpdateTime();
        this.timeInQueue = 0L;
        this.setTimeInQueueLastUpdateTime();
        this.timeInQueueHighWaterMark = 0L;
        this.setTimeInQueueHighWaterMarkLastUpdateTime();
        this.timeInQueueLowWaterMark = Long.MAX_VALUE;
        this.setTimeInQueueLowWaterMarkLastUpdateTime();
        this.queueLengthHighWaterMark = 0L;
        this.setQueueLengthHighWaterMarkLastUpdateTime();
        this.queueLengthLowWaterMark = Long.MAX_VALUE;
        this.setQueueLengthLowWaterMarkLastUpdateTime();
        this.setLastResetTime();
    }

    private void sendResetNotifications() {
        this.sendAttributeChangedNotification("NumberOfRequests", this.numberOfRequests, 0L);
        this.sendAttributeChangedNotification("QueueLength", this.queueLength, 0L);
        this.sendAttributeChangedNotification("QueueLengthHighWaterMark", this.queueLengthHighWaterMark, 0L);
        this.sendAttributeChangedNotification("QueueLengthLowWaterMark", this.queueLengthLowWaterMark, Long.MAX_VALUE);
        this.sendAttributeChangedNotification("TimeInQueue", this.timeInQueue, 0L);
        this.sendAttributeChangedNotification("TimeInQueueHighWaterMark", this.timeInQueueHighWaterMark, 0L);
        this.sendAttributeChangedNotification("TimeInQueueLowWaterMark", this.timeInQueueLowWaterMark, Long.MAX_VALUE);
    }

    @Override
    public Date getLastQueueResetTime() {
        return this.lastResetTime;
    }

    public void update(long queueLength, long timeInQueue) {
        this.setQueueLength(queueLength);
        this.setTimeInQueue(timeInQueue);
        this.incrementNumberOfRequests();
    }

    public void setQueueLength(long queueLength) {
        if (cat.isDebugEnabled()) {
            cat.debug("queueLength service=" + this.service + " length=" + queueLength);
        }
        long oldLength = this.queueLength;
        this.queueLength = queueLength;
        this.setQueueLengthLastUpdateTime();
        if (queueLength > this.queueLengthHighWaterMark) {
            long oldHigh = this.queueLengthHighWaterMark;
            this.queueLengthHighWaterMark = queueLength;
            this.setQueueLengthHighWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("QueueLengthHighWaterMark", oldHigh, this.queueLengthHighWaterMark);
        }
        if (queueLength < this.queueLengthLowWaterMark) {
            long oldLow = this.queueLengthLowWaterMark;
            this.queueLengthLowWaterMark = queueLength;
            this.setQueueLengthLowWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("QueueLengthLowWaterMark", oldLow, this.queueLengthLowWaterMark);
        }
        this.sendAttributeChangedNotification("QueueLength", oldLength, queueLength);
    }

    public void setTimeInQueue(long timeInQueue) {
        if (cat.isDebugEnabled()) {
            cat.debug("timeInQueue service=" + this.service + " time=" + timeInQueue);
        }
        long oldTime = this.timeInQueue;
        this.timeInQueue += timeInQueue;
        this.setTimeInQueueLastUpdateTime();
        if (timeInQueue > this.timeInQueueHighWaterMark) {
            long oldHigh = this.timeInQueueHighWaterMark;
            this.timeInQueueHighWaterMark = timeInQueue;
            this.setTimeInQueueHighWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("TimeInQueueHighWaterMark", oldHigh, this.timeInQueueHighWaterMark);
        }
        if (timeInQueue < this.timeInQueueLowWaterMark) {
            long oldLow = this.timeInQueueLowWaterMark;
            this.timeInQueueLowWaterMark = timeInQueue;
            this.setTimeInQueueLowWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("TimeInQueueLowWaterMark", oldLow, this.timeInQueueLowWaterMark);
        }
        this.sendAttributeChangedNotification("TimeInQueue", oldTime, timeInQueue);
    }

    public void incrementNumberOfRequests() {
        if (cat.isDebugEnabled()) {
            cat.debug("queue request service=" + this.service);
        }
        ++this.numberOfRequests;
        this.sendAttributeChangedNotification("NumberOfRequests", this.numberOfRequests - 1L, this.numberOfRequests);
        this.setNumberOfRequestsLastUpdateTime();
    }

    @Override
    public long getNumberOfRequests() {
        return this.numberOfRequests;
    }

    @Override
    public Date getNumberOfRequestsLastUpdateTime() {
        return this.NumberOfRequestsLastUpdateTime;
    }

    @Override
    public long getTimeInQueue() {
        return this.timeInQueue;
    }

    @Override
    public Date getTimeInQueueLastUpdateTime() {
        return this.timeInQueueLastUpdateTime;
    }

    @Override
    public long getTimeInQueueHighWaterMark() {
        return this.timeInQueueHighWaterMark;
    }

    @Override
    public Date getTimeInQueueHighWaterMarkLastUpdateTime() {
        return this.timeInQueueHighWaterMarkLastUpdateTime;
    }

    @Override
    public long getTimeInQueueLowWaterMark() {
        if (this.timeInQueueLowWaterMark == Long.MAX_VALUE) {
            return 0L;
        }
        return this.timeInQueueLowWaterMark;
    }

    @Override
    public Date getTimeInQueueLowWaterMarkLastUpdateTime() {
        return this.timeInQueueLowWaterMarkLastUpdateTime;
    }

    @Override
    public long getQueueLength() {
        return this.queueLength;
    }

    @Override
    public Date getQueueLengthLastUpdateTime() {
        return this.queueLengthLastUpdateTime;
    }

    @Override
    public long getQueueLengthHighWaterMark() {
        return this.queueLengthHighWaterMark;
    }

    @Override
    public Date getQueueLengthHighWaterMarkLastUpdateTime() {
        return this.queueLengthHighWaterMarkLastUpdateTime;
    }

    @Override
    public long getQueueLengthLowWaterMark() {
        if (this.queueLengthLowWaterMark == Long.MAX_VALUE) {
            return 0L;
        }
        return this.queueLengthLowWaterMark;
    }

    @Override
    public Date getQueueLengthLowWaterMarkLastUpdateTime() {
        return this.queueLengthLowWaterMarkLastUpdateTime;
    }

    private void setLastResetTime() {
        this.lastResetTime.setTime(System.currentTimeMillis());
    }

    private void setNumberOfRequestsLastUpdateTime() {
        this.NumberOfRequestsLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setQueueLengthHighWaterMarkLastUpdateTime() {
        this.queueLengthHighWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setQueueLengthLastUpdateTime() {
        this.queueLengthLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setQueueLengthLowWaterMarkLastUpdateTime() {
        this.queueLengthLowWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setTimeInQueueHighWaterMarkLastUpdateTime() {
        this.timeInQueueHighWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setTimeInQueueLastUpdateTime() {
        this.timeInQueueLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setTimeInQueueLowWaterMarkLastUpdateTime() {
        this.timeInQueueLowWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

