/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.monitoring.CounterMbeanInterface;
import com.cognos.pogo.monitoring.jmx.MetricNotificationSupport;
import com.cognos.pogo.monitoring.jmx.ThreadQueueMetricsMBean;
import java.util.Date;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ThreadQueueMetrics
extends MetricNotificationSupport
implements ThreadQueueMetricsMBean,
CounterMbeanInterface {
    private static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor("METRICS." + ThreadQueueMetrics.class.getName());
    private String name;
    private long numberOfThreadRequests = 0L;
    private Date numberOfThreadRequestsLastUpdateTime = new Date();
    private long timeInThreadQueue = 0L;
    private Date timeInThreadQueueLastUpdateTime = new Date();
    private long timeInThreadQueueHighWaterMark = 0L;
    private Date timeInThreadQueueHighWaterMarkLastUpdateTime = new Date();
    private long timeInThreadQueueLowWaterMark = Long.MAX_VALUE;
    private Date timeInThreadQueueLowWaterMarkLastUpdateTime = new Date();
    private long ThreadQueueLength = 0L;
    private Date ThreadQueueLengthLastUpdateTime = new Date();
    private long ThreadQueueLengthHighWaterMark = 0L;
    private Date ThreadQueueLengthHighWaterMarkLastUpdateTime = new Date();
    private long ThreadQueueLengthLowWaterMark = Long.MAX_VALUE;
    private Date ThreadQueueLengthLowWaterMarkLastUpdateTime = new Date();
    private Date lastResetTime = new Date();
    private final String service;

    public ThreadQueueMetrics(String name, String service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public void reset() {
        if (cat.isDebugEnabled()) {
            cat.debug("reset ThreadQueue service=" + this.service);
        }
        this.sendResetNotifications();
        this.numberOfThreadRequests = 0L;
        this.setNumberOfThreadRequestsLastUpdateTime();
        this.timeInThreadQueue = 0L;
        this.setTimeInThreadQueueLastUpdateTime();
        this.timeInThreadQueueHighWaterMark = 0L;
        this.setTimeInThreadQueueHighWaterMarkLastUpdateTime();
        this.timeInThreadQueueLowWaterMark = Long.MAX_VALUE;
        this.setTimeInThreadQueueLowWaterMarkLastUpdateTime();
        this.ThreadQueueLengthHighWaterMark = 0L;
        this.setThreadQueueLengthHighWaterMarkLastUpdateTime();
        this.ThreadQueueLengthLowWaterMark = Long.MAX_VALUE;
        this.setThreadQueueLengthLowWaterMarkLastUpdateTime();
        this.setLastResetTime();
    }

    private void sendResetNotifications() {
        this.sendAttributeChangedNotification("NumberOfThreadRequests", this.numberOfThreadRequests, 0L);
        this.sendAttributeChangedNotification("ThreadQueueLength", this.ThreadQueueLength, 0L);
        this.sendAttributeChangedNotification("ThreadQueueLengthHighWaterMark", this.ThreadQueueLengthHighWaterMark, 0L);
        this.sendAttributeChangedNotification("ThreadQueueLengthLowWaterMark", this.ThreadQueueLengthLowWaterMark, Long.MAX_VALUE);
        this.sendAttributeChangedNotification("TimeInThreadQueue", this.timeInThreadQueue, 0L);
        this.sendAttributeChangedNotification("TimeInThreadQueueHighWaterMark", this.timeInThreadQueueHighWaterMark, 0L);
        this.sendAttributeChangedNotification("TimeInThreadQueueLowWaterMark", this.timeInThreadQueueLowWaterMark, Long.MAX_VALUE);
    }

    @Override
    public Date getLastThreadQueueResetTime() {
        return this.lastResetTime;
    }

    public void update(long ThreadQueueLength, long timeInThreadQueue) {
        this.setThreadQueueLength(ThreadQueueLength);
        this.setTimeInThreadQueue(timeInThreadQueue);
        this.incrementNumberOfThreadRequests();
    }

    public void setThreadQueueLength(long ThreadQueueLength) {
        if (cat.isDebugEnabled()) {
            cat.debug("ThreadQueueLength service=" + this.service + " length=" + ThreadQueueLength);
        }
        long oldLength = this.ThreadQueueLength;
        this.ThreadQueueLength = ThreadQueueLength;
        this.setThreadQueueLengthLastUpdateTime();
        if (ThreadQueueLength > this.ThreadQueueLengthHighWaterMark) {
            long oldHigh = this.ThreadQueueLengthHighWaterMark;
            this.ThreadQueueLengthHighWaterMark = ThreadQueueLength;
            this.setThreadQueueLengthHighWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("ThreadQueueLengthHighWaterMark", oldHigh, this.ThreadQueueLengthHighWaterMark);
        }
        if (ThreadQueueLength < this.ThreadQueueLengthLowWaterMark) {
            long oldLow = this.ThreadQueueLengthLowWaterMark;
            this.ThreadQueueLengthLowWaterMark = ThreadQueueLength;
            this.setThreadQueueLengthLowWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("ThreadQueueLengthLowWaterMark", oldLow, this.ThreadQueueLengthLowWaterMark);
        }
        this.sendAttributeChangedNotification("ThreadQueueLength", oldLength, ThreadQueueLength);
    }

    public void setTimeInThreadQueue(long timeInThreadQueue) {
        if (cat.isDebugEnabled()) {
            cat.debug("timeInThreadQueue service=" + this.service + " time=" + timeInThreadQueue);
        }
        long oldTime = this.timeInThreadQueue;
        this.timeInThreadQueue = timeInThreadQueue;
        this.setTimeInThreadQueueLastUpdateTime();
        if (timeInThreadQueue > this.timeInThreadQueueHighWaterMark) {
            long oldHigh = this.timeInThreadQueueHighWaterMark;
            this.timeInThreadQueueHighWaterMark = timeInThreadQueue;
            this.setTimeInThreadQueueHighWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("TimeInThreadQueueHighWaterMark", oldHigh, this.timeInThreadQueueHighWaterMark);
        }
        if (timeInThreadQueue < this.timeInThreadQueueLowWaterMark) {
            long oldLow = this.timeInThreadQueueLowWaterMark;
            this.timeInThreadQueueLowWaterMark = timeInThreadQueue;
            this.setTimeInThreadQueueLowWaterMarkLastUpdateTime();
            this.sendAttributeChangedNotification("TimeInThreadQueueLowWaterMark", oldLow, this.timeInThreadQueueLowWaterMark);
        }
        this.sendAttributeChangedNotification("TimeInThreadQueue", oldTime, timeInThreadQueue);
    }

    public void incrementNumberOfThreadRequests() {
        if (cat.isDebugEnabled()) {
            cat.debug("ThreadQueue request service=" + this.service);
        }
        ++this.numberOfThreadRequests;
        this.sendAttributeChangedNotification("NumberOfThreadRequests", this.numberOfThreadRequests - 1L, this.numberOfThreadRequests);
        this.setNumberOfThreadRequestsLastUpdateTime();
    }

    @Override
    public long getNumberOfThreadRequests() {
        return this.numberOfThreadRequests;
    }

    @Override
    public Date getNumberOfThreadRequestsLastUpdateTime() {
        return this.numberOfThreadRequestsLastUpdateTime;
    }

    @Override
    public long getTimeInThreadQueue() {
        return this.timeInThreadQueue;
    }

    @Override
    public Date getTimeInThreadQueueLastUpdateTime() {
        return this.timeInThreadQueueLastUpdateTime;
    }

    @Override
    public long getTimeInThreadQueueHighWaterMark() {
        return this.timeInThreadQueueHighWaterMark;
    }

    @Override
    public Date getTimeInThreadQueueHighWaterMarkLastUpdateTime() {
        return this.timeInThreadQueueHighWaterMarkLastUpdateTime;
    }

    @Override
    public long getTimeInThreadQueueLowWaterMark() {
        if (this.timeInThreadQueueLowWaterMark == Long.MAX_VALUE) {
            return 0L;
        }
        return this.timeInThreadQueueLowWaterMark;
    }

    @Override
    public Date getTimeInThreadQueueLowWaterMarkLastUpdateTime() {
        return this.timeInThreadQueueLowWaterMarkLastUpdateTime;
    }

    @Override
    public long getThreadQueueLength() {
        return this.ThreadQueueLength;
    }

    @Override
    public Date getThreadQueueLengthLastUpdateTime() {
        return this.ThreadQueueLengthLastUpdateTime;
    }

    @Override
    public long getThreadQueueLengthHighWaterMark() {
        return this.ThreadQueueLengthHighWaterMark;
    }

    @Override
    public Date getThreadQueueLengthHighWaterMarkLastUpdateTime() {
        return this.ThreadQueueLengthHighWaterMarkLastUpdateTime;
    }

    @Override
    public long getThreadQueueLengthLowWaterMark() {
        if (this.ThreadQueueLengthLowWaterMark == Long.MAX_VALUE) {
            return 0L;
        }
        return this.ThreadQueueLengthLowWaterMark;
    }

    @Override
    public Date getThreadQueueLengthLowWaterMarkLastUpdateTime() {
        return this.ThreadQueueLengthLowWaterMarkLastUpdateTime;
    }

    private void setLastResetTime() {
        this.lastResetTime.setTime(System.currentTimeMillis());
    }

    private void setNumberOfThreadRequestsLastUpdateTime() {
        this.numberOfThreadRequestsLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setThreadQueueLengthHighWaterMarkLastUpdateTime() {
        this.ThreadQueueLengthHighWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setThreadQueueLengthLastUpdateTime() {
        this.ThreadQueueLengthLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setThreadQueueLengthLowWaterMarkLastUpdateTime() {
        this.ThreadQueueLengthLowWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setTimeInThreadQueueHighWaterMarkLastUpdateTime() {
        this.timeInThreadQueueHighWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setTimeInThreadQueueLastUpdateTime() {
        this.timeInThreadQueueLastUpdateTime.setTime(System.currentTimeMillis());
    }

    private void setTimeInThreadQueueLowWaterMarkLastUpdateTime() {
        this.timeInThreadQueueLowWaterMarkLastUpdateTime.setTime(System.currentTimeMillis());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

