/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.pogo.monitoring.jmx;

import com.cognos.pogo.impl.PogoEngineImpl;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.monitoring.jmx.threshold.SingleAttributeMBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public class UnavailableOperationalStatusMBean
extends SingleAttributeMBean {
    private static final String OPERATIONAL_STATUS = "OperationalStatus";
    private HashMap<String, String> attributeValues = new HashMap();

    @Override
    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        ArrayList<MBeanAttributeInfo> allServices = this.getAllServices();
        allServices.add(new MBeanAttributeInfo(OPERATIONAL_STATUS, String.class.getName(), "Attribute exposed for management", true, false, false));
        this.attributeValues.put(OPERATIONAL_STATUS, ServiceStatus.UNAVAILABLE);
        return allServices.toArray(new MBeanAttributeInfo[allServices.size()]);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String value = this.attributeValues.get(attribute);
        if (value != null) {
            return value;
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes.length == 1 && attributes[0].equals("*")) {
            AttributeList list = new AttributeList(this.attributeValues.size());
            for (Map.Entry<String, String> entry : this.attributeValues.entrySet()) {
                list.add(new Attribute(entry.getKey(), entry.getValue()));
            }
            return list;
        }
        return super.getAttributes(attributes);
    }

    private ArrayList<MBeanAttributeInfo> getAllServices() {
        Set<String> knownComponentList = PogoEngineImpl.getKnownComponentList();
        ArrayList<MBeanAttributeInfo> allServices = new ArrayList<MBeanAttributeInfo>(knownComponentList.size());
        for (String component : knownComponentList) {
            allServices.add(new MBeanAttributeInfo(component, String.class.getName(), "Attribute exposed for management", true, false, false));
            this.attributeValues.put(component, ServiceStatus.UNAVAILABLE);
        }
        return allServices;
    }
}

